// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Snapshot.Json.GcsRepositoryConverter))]
public sealed partial class GcsRepository : Elastic.Clients.Elasticsearch.Snapshot.IRepository
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GcsRepository(Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettings settings)
	{
		Settings = settings;
	}
#if NET7_0_OR_GREATER
	public GcsRepository()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public GcsRepository()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GcsRepository(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The repository settings.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettings Settings { get; set; }

	/// <summary>
	/// <para>
	/// The Google Cloud Storage repository type.
	/// </para>
	/// </summary>
	public string Type => "gcs";

	public string? Uuid { get; set; }
}

public readonly partial struct GcsRepositoryDescriptor
{
	internal Elastic.Clients.Elasticsearch.Snapshot.GcsRepository Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GcsRepositoryDescriptor(Elastic.Clients.Elasticsearch.Snapshot.GcsRepository instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GcsRepositoryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Snapshot.GcsRepository(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Snapshot.GcsRepositoryDescriptor(Elastic.Clients.Elasticsearch.Snapshot.GcsRepository instance) => new Elastic.Clients.Elasticsearch.Snapshot.GcsRepositoryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Snapshot.GcsRepository(Elastic.Clients.Elasticsearch.Snapshot.GcsRepositoryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The repository settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.GcsRepositoryDescriptor Settings(Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettings value)
	{
		Instance.Settings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The repository settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.GcsRepositoryDescriptor Settings(System.Action<Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettingsDescriptor> action)
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.Snapshot.GcsRepositorySettingsDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.GcsRepositoryDescriptor Uuid(string? value)
	{
		Instance.Uuid = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Snapshot.GcsRepository Build(System.Action<Elastic.Clients.Elasticsearch.Snapshot.GcsRepositoryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.GcsRepositoryDescriptor(new Elastic.Clients.Elasticsearch.Snapshot.GcsRepository(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}