// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Snapshot.Json.DetailsInfoConverter))]
public sealed partial class DetailsInfo
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DetailsInfo(Elastic.Clients.Elasticsearch.Snapshot.BlobDetails blob, Elastic.Clients.Elasticsearch.Duration writeElapsed, System.TimeSpan writeElapsedNanos, Elastic.Clients.Elasticsearch.Snapshot.SnapshotNodeInfo writerNode, Elastic.Clients.Elasticsearch.Duration writeThrottled, System.TimeSpan writeThrottledNanos)
	{
		Blob = blob;
		WriteElapsed = writeElapsed;
		WriteElapsedNanos = writeElapsedNanos;
		WriterNode = writerNode;
		WriteThrottled = writeThrottled;
		WriteThrottledNanos = writeThrottledNanos;
	}
#if NET7_0_OR_GREATER
	public DetailsInfo()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DetailsInfo()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DetailsInfo(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A description of the blob that was written and read.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Snapshot.BlobDetails Blob { get; set; }

	/// <summary>
	/// <para>
	/// The elapsed time spent overwriting the blob.
	/// If the blob was not overwritten, this information is omitted.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? OverwriteElapsed { get; set; }

	/// <summary>
	/// <para>
	/// The elapsed time spent overwriting the blob, in nanoseconds.
	/// If the blob was not overwritten, this information is omitted.
	/// </para>
	/// </summary>
	public System.TimeSpan? OverwriteElapsedNanos { get; set; }

	/// <summary>
	/// <para>
	/// The elapsed time spent writing the blob.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Duration WriteElapsed { get; set; }

	/// <summary>
	/// <para>
	/// The elapsed time spent writing the blob, in nanoseconds.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan WriteElapsedNanos { get; set; }

	/// <summary>
	/// <para>
	/// The node which wrote the blob and coordinated the read operations.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Snapshot.SnapshotNodeInfo WriterNode { get; set; }

	/// <summary>
	/// <para>
	/// The length of time spent waiting for the <c>max_snapshot_bytes_per_sec</c> (or <c>indices.recovery.max_bytes_per_sec</c> if the recovery settings for managed services are set) throttle while writing the blob.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Duration WriteThrottled { get; set; }

	/// <summary>
	/// <para>
	/// The length of time spent waiting for the <c>max_snapshot_bytes_per_sec</c> (or <c>indices.recovery.max_bytes_per_sec</c> if the recovery settings for managed services are set) throttle while writing the blob, in nanoseconds.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan WriteThrottledNanos { get; set; }
}