// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot.Json;

public sealed partial class DetailsInfoConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Snapshot.DetailsInfo>
{
	private static readonly System.Text.Json.JsonEncodedText PropBlob = System.Text.Json.JsonEncodedText.Encode("blob");
	private static readonly System.Text.Json.JsonEncodedText PropOverwriteElapsed = System.Text.Json.JsonEncodedText.Encode("overwrite_elapsed");
	private static readonly System.Text.Json.JsonEncodedText PropOverwriteElapsedNanos = System.Text.Json.JsonEncodedText.Encode("overwrite_elapsed_nanos");
	private static readonly System.Text.Json.JsonEncodedText PropWriteElapsed = System.Text.Json.JsonEncodedText.Encode("write_elapsed");
	private static readonly System.Text.Json.JsonEncodedText PropWriteElapsedNanos = System.Text.Json.JsonEncodedText.Encode("write_elapsed_nanos");
	private static readonly System.Text.Json.JsonEncodedText PropWriterNode = System.Text.Json.JsonEncodedText.Encode("writer_node");
	private static readonly System.Text.Json.JsonEncodedText PropWriteThrottled = System.Text.Json.JsonEncodedText.Encode("write_throttled");
	private static readonly System.Text.Json.JsonEncodedText PropWriteThrottledNanos = System.Text.Json.JsonEncodedText.Encode("write_throttled_nanos");

	public override Elastic.Clients.Elasticsearch.Snapshot.DetailsInfo Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.Snapshot.BlobDetails> propBlob = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propOverwriteElapsed = default;
		LocalJsonValue<System.TimeSpan?> propOverwriteElapsedNanos = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration> propWriteElapsed = default;
		LocalJsonValue<System.TimeSpan> propWriteElapsedNanos = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Snapshot.SnapshotNodeInfo> propWriterNode = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration> propWriteThrottled = default;
		LocalJsonValue<System.TimeSpan> propWriteThrottledNanos = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propBlob.TryReadProperty(ref reader, options, PropBlob, null))
			{
				continue;
			}

			if (propOverwriteElapsed.TryReadProperty(ref reader, options, PropOverwriteElapsed, null))
			{
				continue;
			}

			if (propOverwriteElapsedNanos.TryReadProperty(ref reader, options, PropOverwriteElapsedNanos, static System.TimeSpan? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanNanosMarker))))
			{
				continue;
			}

			if (propWriteElapsed.TryReadProperty(ref reader, options, PropWriteElapsed, null))
			{
				continue;
			}

			if (propWriteElapsedNanos.TryReadProperty(ref reader, options, PropWriteElapsedNanos, static System.TimeSpan (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanNanosMarker))))
			{
				continue;
			}

			if (propWriterNode.TryReadProperty(ref reader, options, PropWriterNode, null))
			{
				continue;
			}

			if (propWriteThrottled.TryReadProperty(ref reader, options, PropWriteThrottled, null))
			{
				continue;
			}

			if (propWriteThrottledNanos.TryReadProperty(ref reader, options, PropWriteThrottledNanos, static System.TimeSpan (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanNanosMarker))))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Snapshot.DetailsInfo(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Blob = propBlob.Value,
			OverwriteElapsed = propOverwriteElapsed.Value,
			OverwriteElapsedNanos = propOverwriteElapsedNanos.Value,
			WriteElapsed = propWriteElapsed.Value,
			WriteElapsedNanos = propWriteElapsedNanos.Value,
			WriterNode = propWriterNode.Value,
			WriteThrottled = propWriteThrottled.Value,
			WriteThrottledNanos = propWriteThrottledNanos.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Snapshot.DetailsInfo value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropBlob, value.Blob, null, null);
		writer.WriteProperty(options, PropOverwriteElapsed, value.OverwriteElapsed, null, null);
		writer.WriteProperty(options, PropOverwriteElapsedNanos, value.OverwriteElapsedNanos, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan? v) => w.WriteNullableValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanNanosMarker)));
		writer.WriteProperty(options, PropWriteElapsed, value.WriteElapsed, null, null);
		writer.WriteProperty(options, PropWriteElapsedNanos, value.WriteElapsedNanos, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan v) => w.WriteValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanNanosMarker)));
		writer.WriteProperty(options, PropWriterNode, value.WriterNode, null, null);
		writer.WriteProperty(options, PropWriteThrottled, value.WriteThrottled, null, null);
		writer.WriteProperty(options, PropWriteThrottledNanos, value.WriteThrottledNanos, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan v) => w.WriteValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanNanosMarker)));
		writer.WriteEndObject();
	}
}