// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Snapshot.Json.BlobDetailsConverter))]
public sealed partial class BlobDetails
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BlobDetails(string name, bool overwritten, bool readEarly, long readEnd, Elastic.Clients.Elasticsearch.Snapshot.ReadBlobDetails reads, long readStart, Elastic.Clients.Elasticsearch.ByteSize size, long sizeBytes)
	{
		Name = name;
		Overwritten = overwritten;
		ReadEarly = readEarly;
		ReadEnd = readEnd;
		Reads = reads;
		ReadStart = readStart;
		Size = size;
		SizeBytes = sizeBytes;
	}
#if NET7_0_OR_GREATER
	public BlobDetails()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public BlobDetails()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal BlobDetails(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The name of the blob.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Name { get; set; }

	/// <summary>
	/// <para>
	/// Indicates whether the blob was overwritten while the read operations were ongoing.
	/// /**
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool Overwritten { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool ReadEarly { get; set; }

	/// <summary>
	/// <para>
	/// The position, in bytes, at which read operations completed.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long ReadEnd { get; set; }

	/// <summary>
	/// <para>
	/// A description of every read operation performed on the blob.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Snapshot.ReadBlobDetails Reads { get; set; }

	/// <summary>
	/// <para>
	/// The position, in bytes, at which read operations started.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long ReadStart { get; set; }

	/// <summary>
	/// <para>
	/// The size of the blob.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.ByteSize Size { get; set; }

	/// <summary>
	/// <para>
	/// The size of the blob in bytes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long SizeBytes { get; set; }
}