// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot.Json;

public sealed partial class BlobDetailsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Snapshot.BlobDetails>
{
	private static readonly System.Text.Json.JsonEncodedText PropName = System.Text.Json.JsonEncodedText.Encode("name");
	private static readonly System.Text.Json.JsonEncodedText PropOverwritten = System.Text.Json.JsonEncodedText.Encode("overwritten");
	private static readonly System.Text.Json.JsonEncodedText PropReadEarly = System.Text.Json.JsonEncodedText.Encode("read_early");
	private static readonly System.Text.Json.JsonEncodedText PropReadEnd = System.Text.Json.JsonEncodedText.Encode("read_end");
	private static readonly System.Text.Json.JsonEncodedText PropReads = System.Text.Json.JsonEncodedText.Encode("reads");
	private static readonly System.Text.Json.JsonEncodedText PropReadStart = System.Text.Json.JsonEncodedText.Encode("read_start");
	private static readonly System.Text.Json.JsonEncodedText PropSize = System.Text.Json.JsonEncodedText.Encode("size");
	private static readonly System.Text.Json.JsonEncodedText PropSizeBytes = System.Text.Json.JsonEncodedText.Encode("size_bytes");

	public override Elastic.Clients.Elasticsearch.Snapshot.BlobDetails Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string> propName = default;
		LocalJsonValue<bool> propOverwritten = default;
		LocalJsonValue<bool> propReadEarly = default;
		LocalJsonValue<long> propReadEnd = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Snapshot.ReadBlobDetails> propReads = default;
		LocalJsonValue<long> propReadStart = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize> propSize = default;
		LocalJsonValue<long> propSizeBytes = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propName.TryReadProperty(ref reader, options, PropName, null))
			{
				continue;
			}

			if (propOverwritten.TryReadProperty(ref reader, options, PropOverwritten, null))
			{
				continue;
			}

			if (propReadEarly.TryReadProperty(ref reader, options, PropReadEarly, null))
			{
				continue;
			}

			if (propReadEnd.TryReadProperty(ref reader, options, PropReadEnd, null))
			{
				continue;
			}

			if (propReads.TryReadProperty(ref reader, options, PropReads, null))
			{
				continue;
			}

			if (propReadStart.TryReadProperty(ref reader, options, PropReadStart, null))
			{
				continue;
			}

			if (propSize.TryReadProperty(ref reader, options, PropSize, null))
			{
				continue;
			}

			if (propSizeBytes.TryReadProperty(ref reader, options, PropSizeBytes, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Snapshot.BlobDetails(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Name = propName.Value,
			Overwritten = propOverwritten.Value,
			ReadEarly = propReadEarly.Value,
			ReadEnd = propReadEnd.Value,
			Reads = propReads.Value,
			ReadStart = propReadStart.Value,
			Size = propSize.Value,
			SizeBytes = propSizeBytes.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Snapshot.BlobDetails value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropName, value.Name, null, null);
		writer.WriteProperty(options, PropOverwritten, value.Overwritten, null, null);
		writer.WriteProperty(options, PropReadEarly, value.ReadEarly, null, null);
		writer.WriteProperty(options, PropReadEnd, value.ReadEnd, null, null);
		writer.WriteProperty(options, PropReads, value.Reads, null, null);
		writer.WriteProperty(options, PropReadStart, value.ReadStart, null, null);
		writer.WriteProperty(options, PropSize, value.Size, null, null);
		writer.WriteProperty(options, PropSizeBytes, value.SizeBytes, null, null);
		writer.WriteEndObject();
	}
}