// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Snapshot.Json.AzureRepositoryConverter))]
public sealed partial class AzureRepository : Elastic.Clients.Elasticsearch.Snapshot.IRepository
{
#if NET7_0_OR_GREATER
	public AzureRepository()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public AzureRepository()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AzureRepository(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The repository settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.AzureRepositorySettings? Settings { get; set; }

	/// <summary>
	/// <para>
	/// The Azure repository type.
	/// </para>
	/// </summary>
	public string Type => "azure";

	public string? Uuid { get; set; }
}

public readonly partial struct AzureRepositoryDescriptor
{
	internal Elastic.Clients.Elasticsearch.Snapshot.AzureRepository Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AzureRepositoryDescriptor(Elastic.Clients.Elasticsearch.Snapshot.AzureRepository instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AzureRepositoryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Snapshot.AzureRepository(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Snapshot.AzureRepositoryDescriptor(Elastic.Clients.Elasticsearch.Snapshot.AzureRepository instance) => new Elastic.Clients.Elasticsearch.Snapshot.AzureRepositoryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Snapshot.AzureRepository(Elastic.Clients.Elasticsearch.Snapshot.AzureRepositoryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The repository settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.AzureRepositoryDescriptor Settings(Elastic.Clients.Elasticsearch.Snapshot.AzureRepositorySettings? value)
	{
		Instance.Settings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The repository settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.AzureRepositoryDescriptor Settings()
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.Snapshot.AzureRepositorySettingsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The repository settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.AzureRepositoryDescriptor Settings(System.Action<Elastic.Clients.Elasticsearch.Snapshot.AzureRepositorySettingsDescriptor>? action)
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.Snapshot.AzureRepositorySettingsDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.AzureRepositoryDescriptor Uuid(string? value)
	{
		Instance.Uuid = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Snapshot.AzureRepository Build(System.Action<Elastic.Clients.Elasticsearch.Snapshot.AzureRepositoryDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Snapshot.AzureRepository(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Snapshot.AzureRepositoryDescriptor(new Elastic.Clients.Elasticsearch.Snapshot.AzureRepository(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}