// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Simulate;

/// <summary>
/// <para>
/// The results of ingest simulation on a single document. The _source of the document contains
/// the results after running all pipelines listed in executed_pipelines on the document. The
/// list of executed pipelines is derived from the pipelines that would be executed if this
/// document had been ingested into _index.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Simulate.Json.IngestDocumentSimulationConverter))]
public sealed partial class IngestDocumentSimulation
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IngestDocumentSimulation(System.Collections.Generic.IReadOnlyCollection<string> executedPipelines, string id, string index, System.Collections.Generic.IReadOnlyDictionary<string, object> source, long version)
	{
		ExecutedPipelines = executedPipelines;
		Id = id;
		Index = index;
		Source = source;
		Version = version;
	}
#if NET7_0_OR_GREATER
	public IngestDocumentSimulation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public IngestDocumentSimulation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IngestDocumentSimulation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Any error resulting from simulatng ingest on this doc. This can be an error generated by
	/// executing a processor, or a mapping validation error when simulating indexing the resulting
	/// doc.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ErrorCause? Error { get; set; }

	/// <summary>
	/// <para>
	/// A list of the names of the pipelines executed on this document.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<string> ExecutedPipelines { get; set; }

	/// <summary>
	/// <para>
	/// Identifier for the document.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Id { get; set; }

	/// <summary>
	/// <para>
	/// A list of the fields that would be ignored at the indexing step. For example, a field whose
	/// value is larger than the allowed limit would make it through all of the pipelines, but
	/// would not be indexed into Elasticsearch.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyCollection<System.Collections.Generic.IReadOnlyDictionary<string, string>>? IgnoredFields { get; set; }

	/// <summary>
	/// <para>
	/// Name of the index that the document would be indexed into if this were not a simulation.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Index { get; set; }

	/// <summary>
	/// <para>
	/// Additional metadata
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyDictionary<string, string>? Metadata { get; set; }

	/// <summary>
	/// <para>
	/// JSON body for the document.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyDictionary<string, object> Source { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Version { get; set; }
}