// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.SegmentsStatsConverter))]
public sealed partial class SegmentsStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SegmentsStats(int count, long docValuesMemoryInBytes, System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.IndexManagement.ShardFileSizeInfo> fileSizes, long fixedBitSetMemoryInBytes, long indexWriterMemoryInBytes, long maxUnsafeAutoIdTimestamp, long memoryInBytes, long normsMemoryInBytes, long pointsMemoryInBytes, long storedFieldsMemoryInBytes, long termsMemoryInBytes, long termVectorsMemoryInBytes, long versionMapMemoryInBytes)
	{
		Count = count;
		DocValuesMemoryInBytes = docValuesMemoryInBytes;
		FileSizes = fileSizes;
		FixedBitSetMemoryInBytes = fixedBitSetMemoryInBytes;
		IndexWriterMemoryInBytes = indexWriterMemoryInBytes;
		MaxUnsafeAutoIdTimestamp = maxUnsafeAutoIdTimestamp;
		MemoryInBytes = memoryInBytes;
		NormsMemoryInBytes = normsMemoryInBytes;
		PointsMemoryInBytes = pointsMemoryInBytes;
		StoredFieldsMemoryInBytes = storedFieldsMemoryInBytes;
		TermsMemoryInBytes = termsMemoryInBytes;
		TermVectorsMemoryInBytes = termVectorsMemoryInBytes;
		VersionMapMemoryInBytes = versionMapMemoryInBytes;
	}
#if NET7_0_OR_GREATER
	public SegmentsStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public SegmentsStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SegmentsStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Total number of segments across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int Count { get; set; }

	/// <summary>
	/// <para>
	/// Total amount of memory used for doc values across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? DocValuesMemory { get; set; }

	/// <summary>
	/// <para>
	/// Total amount, in bytes, of memory used for doc values across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long DocValuesMemoryInBytes { get; set; }

	/// <summary>
	/// <para>
	/// This object is not populated by the cluster stats API.
	/// To get information on segment files, use the node stats API.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.IndexManagement.ShardFileSizeInfo> FileSizes { get; set; }

	/// <summary>
	/// <para>
	/// Total amount of memory used by fixed bit sets across all shards assigned to selected nodes.
	/// Fixed bit sets are used for nested object field types and type filters for join fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? FixedBitSet { get; set; }

	/// <summary>
	/// <para>
	/// Total amount of memory, in bytes, used by fixed bit sets across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long FixedBitSetMemoryInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Total amount of memory used by all index writers across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? IndexWriterMemory { get; set; }

	/// <summary>
	/// <para>
	/// Total amount, in bytes, of memory used by all index writers across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long IndexWriterMemoryInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Unix timestamp, in milliseconds, of the most recently retried indexing request.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long MaxUnsafeAutoIdTimestamp { get; set; }

	/// <summary>
	/// <para>
	/// Total amount of memory used for segments across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? Memory { get; set; }

	/// <summary>
	/// <para>
	/// Total amount, in bytes, of memory used for segments across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long MemoryInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Total amount of memory used for normalization factors across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? NormsMemory { get; set; }

	/// <summary>
	/// <para>
	/// Total amount, in bytes, of memory used for normalization factors across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long NormsMemoryInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Total amount of memory used for points across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? PointsMemory { get; set; }

	/// <summary>
	/// <para>
	/// Total amount, in bytes, of memory used for points across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long PointsMemoryInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Total amount of memory used for stored fields across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? StoredFieldsMemory { get; set; }

	/// <summary>
	/// <para>
	/// Total amount, in bytes, of memory used for stored fields across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long StoredFieldsMemoryInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Total amount of memory used for terms across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? TermsMemory { get; set; }

	/// <summary>
	/// <para>
	/// Total amount, in bytes, of memory used for terms across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long TermsMemoryInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Total amount of memory used for term vectors across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? TermVectorsMemory { get; set; }

	/// <summary>
	/// <para>
	/// Total amount, in bytes, of memory used for term vectors across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long TermVectorsMemoryInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Total amount of memory used by all version maps across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? VersionMapMemory { get; set; }

	/// <summary>
	/// <para>
	/// Total amount, in bytes, of memory used by all version maps across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long VersionMapMemoryInBytes { get; set; }
}