// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class SegmentsStatsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.SegmentsStats>
{
	private static readonly System.Text.Json.JsonEncodedText PropCount = System.Text.Json.JsonEncodedText.Encode("count");
	private static readonly System.Text.Json.JsonEncodedText PropDocValuesMemory = System.Text.Json.JsonEncodedText.Encode("doc_values_memory");
	private static readonly System.Text.Json.JsonEncodedText PropDocValuesMemoryInBytes = System.Text.Json.JsonEncodedText.Encode("doc_values_memory_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropFileSizes = System.Text.Json.JsonEncodedText.Encode("file_sizes");
	private static readonly System.Text.Json.JsonEncodedText PropFixedBitSet = System.Text.Json.JsonEncodedText.Encode("fixed_bit_set");
	private static readonly System.Text.Json.JsonEncodedText PropFixedBitSetMemoryInBytes = System.Text.Json.JsonEncodedText.Encode("fixed_bit_set_memory_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropIndexWriterMemory = System.Text.Json.JsonEncodedText.Encode("index_writer_memory");
	private static readonly System.Text.Json.JsonEncodedText PropIndexWriterMemoryInBytes = System.Text.Json.JsonEncodedText.Encode("index_writer_memory_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropMaxUnsafeAutoIdTimestamp = System.Text.Json.JsonEncodedText.Encode("max_unsafe_auto_id_timestamp");
	private static readonly System.Text.Json.JsonEncodedText PropMemory = System.Text.Json.JsonEncodedText.Encode("memory");
	private static readonly System.Text.Json.JsonEncodedText PropMemoryInBytes = System.Text.Json.JsonEncodedText.Encode("memory_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropNormsMemory = System.Text.Json.JsonEncodedText.Encode("norms_memory");
	private static readonly System.Text.Json.JsonEncodedText PropNormsMemoryInBytes = System.Text.Json.JsonEncodedText.Encode("norms_memory_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropPointsMemory = System.Text.Json.JsonEncodedText.Encode("points_memory");
	private static readonly System.Text.Json.JsonEncodedText PropPointsMemoryInBytes = System.Text.Json.JsonEncodedText.Encode("points_memory_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropStoredFieldsMemory = System.Text.Json.JsonEncodedText.Encode("stored_fields_memory");
	private static readonly System.Text.Json.JsonEncodedText PropStoredFieldsMemoryInBytes = System.Text.Json.JsonEncodedText.Encode("stored_fields_memory_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropTermsMemory = System.Text.Json.JsonEncodedText.Encode("terms_memory");
	private static readonly System.Text.Json.JsonEncodedText PropTermsMemoryInBytes = System.Text.Json.JsonEncodedText.Encode("terms_memory_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropTermVectorsMemory = System.Text.Json.JsonEncodedText.Encode("term_vectors_memory");
	private static readonly System.Text.Json.JsonEncodedText PropTermVectorsMemoryInBytes = System.Text.Json.JsonEncodedText.Encode("term_vectors_memory_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropVersionMapMemory = System.Text.Json.JsonEncodedText.Encode("version_map_memory");
	private static readonly System.Text.Json.JsonEncodedText PropVersionMapMemoryInBytes = System.Text.Json.JsonEncodedText.Encode("version_map_memory_in_bytes");

	public override Elastic.Clients.Elasticsearch.SegmentsStats Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<int> propCount = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propDocValuesMemory = default;
		LocalJsonValue<long> propDocValuesMemoryInBytes = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.IndexManagement.ShardFileSizeInfo>> propFileSizes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propFixedBitSet = default;
		LocalJsonValue<long> propFixedBitSetMemoryInBytes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propIndexWriterMemory = default;
		LocalJsonValue<long> propIndexWriterMemoryInBytes = default;
		LocalJsonValue<long> propMaxUnsafeAutoIdTimestamp = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propMemory = default;
		LocalJsonValue<long> propMemoryInBytes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propNormsMemory = default;
		LocalJsonValue<long> propNormsMemoryInBytes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propPointsMemory = default;
		LocalJsonValue<long> propPointsMemoryInBytes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propStoredFieldsMemory = default;
		LocalJsonValue<long> propStoredFieldsMemoryInBytes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propTermsMemory = default;
		LocalJsonValue<long> propTermsMemoryInBytes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propTermVectorsMemory = default;
		LocalJsonValue<long> propTermVectorsMemoryInBytes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propVersionMapMemory = default;
		LocalJsonValue<long> propVersionMapMemoryInBytes = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propCount.TryReadProperty(ref reader, options, PropCount, null))
			{
				continue;
			}

			if (propDocValuesMemory.TryReadProperty(ref reader, options, PropDocValuesMemory, null))
			{
				continue;
			}

			if (propDocValuesMemoryInBytes.TryReadProperty(ref reader, options, PropDocValuesMemoryInBytes, null))
			{
				continue;
			}

			if (propFileSizes.TryReadProperty(ref reader, options, PropFileSizes, static System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.IndexManagement.ShardFileSizeInfo> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, Elastic.Clients.Elasticsearch.IndexManagement.ShardFileSizeInfo>(o, null, null)!))
			{
				continue;
			}

			if (propFixedBitSet.TryReadProperty(ref reader, options, PropFixedBitSet, null))
			{
				continue;
			}

			if (propFixedBitSetMemoryInBytes.TryReadProperty(ref reader, options, PropFixedBitSetMemoryInBytes, null))
			{
				continue;
			}

			if (propIndexWriterMemory.TryReadProperty(ref reader, options, PropIndexWriterMemory, null))
			{
				continue;
			}

			if (propIndexWriterMemoryInBytes.TryReadProperty(ref reader, options, PropIndexWriterMemoryInBytes, null))
			{
				continue;
			}

			if (propMaxUnsafeAutoIdTimestamp.TryReadProperty(ref reader, options, PropMaxUnsafeAutoIdTimestamp, null))
			{
				continue;
			}

			if (propMemory.TryReadProperty(ref reader, options, PropMemory, null))
			{
				continue;
			}

			if (propMemoryInBytes.TryReadProperty(ref reader, options, PropMemoryInBytes, null))
			{
				continue;
			}

			if (propNormsMemory.TryReadProperty(ref reader, options, PropNormsMemory, null))
			{
				continue;
			}

			if (propNormsMemoryInBytes.TryReadProperty(ref reader, options, PropNormsMemoryInBytes, null))
			{
				continue;
			}

			if (propPointsMemory.TryReadProperty(ref reader, options, PropPointsMemory, null))
			{
				continue;
			}

			if (propPointsMemoryInBytes.TryReadProperty(ref reader, options, PropPointsMemoryInBytes, null))
			{
				continue;
			}

			if (propStoredFieldsMemory.TryReadProperty(ref reader, options, PropStoredFieldsMemory, null))
			{
				continue;
			}

			if (propStoredFieldsMemoryInBytes.TryReadProperty(ref reader, options, PropStoredFieldsMemoryInBytes, null))
			{
				continue;
			}

			if (propTermsMemory.TryReadProperty(ref reader, options, PropTermsMemory, null))
			{
				continue;
			}

			if (propTermsMemoryInBytes.TryReadProperty(ref reader, options, PropTermsMemoryInBytes, null))
			{
				continue;
			}

			if (propTermVectorsMemory.TryReadProperty(ref reader, options, PropTermVectorsMemory, null))
			{
				continue;
			}

			if (propTermVectorsMemoryInBytes.TryReadProperty(ref reader, options, PropTermVectorsMemoryInBytes, null))
			{
				continue;
			}

			if (propVersionMapMemory.TryReadProperty(ref reader, options, PropVersionMapMemory, null))
			{
				continue;
			}

			if (propVersionMapMemoryInBytes.TryReadProperty(ref reader, options, PropVersionMapMemoryInBytes, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.SegmentsStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Count = propCount.Value,
			DocValuesMemory = propDocValuesMemory.Value,
			DocValuesMemoryInBytes = propDocValuesMemoryInBytes.Value,
			FileSizes = propFileSizes.Value,
			FixedBitSet = propFixedBitSet.Value,
			FixedBitSetMemoryInBytes = propFixedBitSetMemoryInBytes.Value,
			IndexWriterMemory = propIndexWriterMemory.Value,
			IndexWriterMemoryInBytes = propIndexWriterMemoryInBytes.Value,
			MaxUnsafeAutoIdTimestamp = propMaxUnsafeAutoIdTimestamp.Value,
			Memory = propMemory.Value,
			MemoryInBytes = propMemoryInBytes.Value,
			NormsMemory = propNormsMemory.Value,
			NormsMemoryInBytes = propNormsMemoryInBytes.Value,
			PointsMemory = propPointsMemory.Value,
			PointsMemoryInBytes = propPointsMemoryInBytes.Value,
			StoredFieldsMemory = propStoredFieldsMemory.Value,
			StoredFieldsMemoryInBytes = propStoredFieldsMemoryInBytes.Value,
			TermsMemory = propTermsMemory.Value,
			TermsMemoryInBytes = propTermsMemoryInBytes.Value,
			TermVectorsMemory = propTermVectorsMemory.Value,
			TermVectorsMemoryInBytes = propTermVectorsMemoryInBytes.Value,
			VersionMapMemory = propVersionMapMemory.Value,
			VersionMapMemoryInBytes = propVersionMapMemoryInBytes.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.SegmentsStats value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropCount, value.Count, null, null);
		writer.WriteProperty(options, PropDocValuesMemory, value.DocValuesMemory, null, null);
		writer.WriteProperty(options, PropDocValuesMemoryInBytes, value.DocValuesMemoryInBytes, null, null);
		writer.WriteProperty(options, PropFileSizes, value.FileSizes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.IndexManagement.ShardFileSizeInfo> v) => w.WriteDictionaryValue<string, Elastic.Clients.Elasticsearch.IndexManagement.ShardFileSizeInfo>(o, v, null, null));
		writer.WriteProperty(options, PropFixedBitSet, value.FixedBitSet, null, null);
		writer.WriteProperty(options, PropFixedBitSetMemoryInBytes, value.FixedBitSetMemoryInBytes, null, null);
		writer.WriteProperty(options, PropIndexWriterMemory, value.IndexWriterMemory, null, null);
		writer.WriteProperty(options, PropIndexWriterMemoryInBytes, value.IndexWriterMemoryInBytes, null, null);
		writer.WriteProperty(options, PropMaxUnsafeAutoIdTimestamp, value.MaxUnsafeAutoIdTimestamp, null, null);
		writer.WriteProperty(options, PropMemory, value.Memory, null, null);
		writer.WriteProperty(options, PropMemoryInBytes, value.MemoryInBytes, null, null);
		writer.WriteProperty(options, PropNormsMemory, value.NormsMemory, null, null);
		writer.WriteProperty(options, PropNormsMemoryInBytes, value.NormsMemoryInBytes, null, null);
		writer.WriteProperty(options, PropPointsMemory, value.PointsMemory, null, null);
		writer.WriteProperty(options, PropPointsMemoryInBytes, value.PointsMemoryInBytes, null, null);
		writer.WriteProperty(options, PropStoredFieldsMemory, value.StoredFieldsMemory, null, null);
		writer.WriteProperty(options, PropStoredFieldsMemoryInBytes, value.StoredFieldsMemoryInBytes, null, null);
		writer.WriteProperty(options, PropTermsMemory, value.TermsMemory, null, null);
		writer.WriteProperty(options, PropTermsMemoryInBytes, value.TermsMemoryInBytes, null, null);
		writer.WriteProperty(options, PropTermVectorsMemory, value.TermVectorsMemory, null, null);
		writer.WriteProperty(options, PropTermVectorsMemoryInBytes, value.TermVectorsMemoryInBytes, null, null);
		writer.WriteProperty(options, PropVersionMapMemory, value.VersionMapMemory, null, null);
		writer.WriteProperty(options, PropVersionMapMemoryInBytes, value.VersionMapMemoryInBytes, null, null);
		writer.WriteEndObject();
	}
}