// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.UserQueryConverter))]
public sealed partial class UserQuery
{
	internal string? VariantType { get; set; }
	internal object? Variant { get; set; }
#if NET7_0_OR_GREATER
	public UserQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public UserQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal UserQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// matches users matching boolean combinations of other queries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQuery? Bool { get => GetVariant<Elastic.Clients.Elasticsearch.QueryDsl.BoolQuery>("bool"); set => SetVariant("bool", value); }

	/// <summary>
	/// <para>
	/// Returns users that contain an indexed value for a field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.ExistsQuery? Exists { get => GetVariant<Elastic.Clients.Elasticsearch.QueryDsl.ExistsQuery>("exists"); set => SetVariant("exists", value); }

	/// <summary>
	/// <para>
	/// Returns users based on their IDs.
	/// This query uses the user document IDs stored in the <c>_id</c> field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IdsQuery? Ids { get => GetVariant<Elastic.Clients.Elasticsearch.QueryDsl.IdsQuery>("ids"); set => SetVariant("ids", value); }

	/// <summary>
	/// <para>
	/// Returns users that match a provided text, number, date or boolean value.
	/// The provided text is analyzed before matching.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchQuery? Match { get => GetVariant<Elastic.Clients.Elasticsearch.QueryDsl.MatchQuery>("match"); set => SetVariant("match", value); }

	/// <summary>
	/// <para>
	/// Matches all users, giving them all a <c>_score</c> of 1.0.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MatchAllQuery? MatchAll { get => GetVariant<Elastic.Clients.Elasticsearch.QueryDsl.MatchAllQuery>("match_all"); set => SetVariant("match_all", value); }

	/// <summary>
	/// <para>
	/// Returns users that contain a specific prefix in a provided field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.PrefixQuery? Prefix { get => GetVariant<Elastic.Clients.Elasticsearch.QueryDsl.PrefixQuery>("prefix"); set => SetVariant("prefix", value); }

	/// <summary>
	/// <para>
	/// Returns users that contain terms within a provided range.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.IRangeQuery? Range { get => GetVariant<Elastic.Clients.Elasticsearch.QueryDsl.IRangeQuery>("range"); set => SetVariant("range", value); }

	/// <summary>
	/// <para>
	/// Returns users based on a provided query string, using a parser with a limited but fault-tolerant syntax.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQuery? SimpleQueryString { get => GetVariant<Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQuery>("simple_query_string"); set => SetVariant("simple_query_string", value); }

	/// <summary>
	/// <para>
	/// Returns users that contain an exact term in a provided field.
	/// To return a document, the query term must exactly match the queried field's value, including whitespace and capitalization.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TermQuery? Term { get => GetVariant<Elastic.Clients.Elasticsearch.QueryDsl.TermQuery>("term"); set => SetVariant("term", value); }

	/// <summary>
	/// <para>
	/// Returns users that contain one or more exact terms in a provided field.
	/// To return a document, one or more terms must exactly match a field value, including whitespace and capitalization.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.TermsQuery? Terms { get => GetVariant<Elastic.Clients.Elasticsearch.QueryDsl.TermsQuery>("terms"); set => SetVariant("terms", value); }

	/// <summary>
	/// <para>
	/// Returns users that contain terms matching a wildcard pattern.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.WildcardQuery? Wildcard { get => GetVariant<Elastic.Clients.Elasticsearch.QueryDsl.WildcardQuery>("wildcard"); set => SetVariant("wildcard", value); }

	public static implicit operator Elastic.Clients.Elasticsearch.Security.UserQuery(Elastic.Clients.Elasticsearch.QueryDsl.BoolQuery value) => new Elastic.Clients.Elasticsearch.Security.UserQuery { Bool = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Security.UserQuery(Elastic.Clients.Elasticsearch.QueryDsl.ExistsQuery value) => new Elastic.Clients.Elasticsearch.Security.UserQuery { Exists = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Security.UserQuery(Elastic.Clients.Elasticsearch.QueryDsl.IdsQuery value) => new Elastic.Clients.Elasticsearch.Security.UserQuery { Ids = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Security.UserQuery(Elastic.Clients.Elasticsearch.QueryDsl.MatchQuery value) => new Elastic.Clients.Elasticsearch.Security.UserQuery { Match = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Security.UserQuery(Elastic.Clients.Elasticsearch.QueryDsl.MatchAllQuery value) => new Elastic.Clients.Elasticsearch.Security.UserQuery { MatchAll = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Security.UserQuery(Elastic.Clients.Elasticsearch.QueryDsl.PrefixQuery value) => new Elastic.Clients.Elasticsearch.Security.UserQuery { Prefix = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Security.UserQuery(Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQuery value) => new Elastic.Clients.Elasticsearch.Security.UserQuery { Range = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Security.UserQuery(Elastic.Clients.Elasticsearch.QueryDsl.NumberRangeQuery value) => new Elastic.Clients.Elasticsearch.Security.UserQuery { Range = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Security.UserQuery(Elastic.Clients.Elasticsearch.QueryDsl.TermRangeQuery value) => new Elastic.Clients.Elasticsearch.Security.UserQuery { Range = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Security.UserQuery(Elastic.Clients.Elasticsearch.QueryDsl.UntypedRangeQuery value) => new Elastic.Clients.Elasticsearch.Security.UserQuery { Range = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Security.UserQuery(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQuery value) => new Elastic.Clients.Elasticsearch.Security.UserQuery { SimpleQueryString = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Security.UserQuery(Elastic.Clients.Elasticsearch.QueryDsl.TermQuery value) => new Elastic.Clients.Elasticsearch.Security.UserQuery { Term = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Security.UserQuery(Elastic.Clients.Elasticsearch.QueryDsl.TermsQuery value) => new Elastic.Clients.Elasticsearch.Security.UserQuery { Terms = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Security.UserQuery(Elastic.Clients.Elasticsearch.QueryDsl.WildcardQuery value) => new Elastic.Clients.Elasticsearch.Security.UserQuery { Wildcard = value };

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private T? GetVariant<T>(string type)
	{
		if (string.Equals(VariantType, type, System.StringComparison.Ordinal) && Variant is T result)
		{
			return result;
		}

		return default;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private void SetVariant<T>(string type, T? value)
	{
		VariantType = type;
		Variant = value;
	}
}

public readonly partial struct UserQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Security.UserQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UserQueryDescriptor(Elastic.Clients.Elasticsearch.Security.UserQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UserQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.UserQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Security.UserQuery instance) => new Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.UserQuery(Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// matches users matching boolean combinations of other queries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> Bool(Elastic.Clients.Elasticsearch.QueryDsl.BoolQuery? value)
	{
		Instance.Bool = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// matches users matching boolean combinations of other queries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> Bool()
	{
		Instance.Bool = Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// matches users matching boolean combinations of other queries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> Bool(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<TDocument>>? action)
	{
		Instance.Bool = Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain an indexed value for a field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> Exists(Elastic.Clients.Elasticsearch.QueryDsl.ExistsQuery? value)
	{
		Instance.Exists = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain an indexed value for a field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> Exists(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.ExistsQueryDescriptor<TDocument>> action)
	{
		Instance.Exists = Elastic.Clients.Elasticsearch.QueryDsl.ExistsQueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users based on their IDs.
	/// This query uses the user document IDs stored in the <c>_id</c> field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> Ids(Elastic.Clients.Elasticsearch.QueryDsl.IdsQuery? value)
	{
		Instance.Ids = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users based on their IDs.
	/// This query uses the user document IDs stored in the <c>_id</c> field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> Ids()
	{
		Instance.Ids = Elastic.Clients.Elasticsearch.QueryDsl.IdsQueryDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users based on their IDs.
	/// This query uses the user document IDs stored in the <c>_id</c> field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> Ids(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.IdsQueryDescriptor>? action)
	{
		Instance.Ids = Elastic.Clients.Elasticsearch.QueryDsl.IdsQueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that match a provided text, number, date or boolean value.
	/// The provided text is analyzed before matching.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> Match(Elastic.Clients.Elasticsearch.QueryDsl.MatchQuery? value)
	{
		Instance.Match = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that match a provided text, number, date or boolean value.
	/// The provided text is analyzed before matching.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> Match(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.MatchQueryDescriptor<TDocument>> action)
	{
		Instance.Match = Elastic.Clients.Elasticsearch.QueryDsl.MatchQueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Matches all users, giving them all a <c>_score</c> of 1.0.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> MatchAll(Elastic.Clients.Elasticsearch.QueryDsl.MatchAllQuery? value)
	{
		Instance.MatchAll = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Matches all users, giving them all a <c>_score</c> of 1.0.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> MatchAll()
	{
		Instance.MatchAll = Elastic.Clients.Elasticsearch.QueryDsl.MatchAllQueryDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Matches all users, giving them all a <c>_score</c> of 1.0.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> MatchAll(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.MatchAllQueryDescriptor>? action)
	{
		Instance.MatchAll = Elastic.Clients.Elasticsearch.QueryDsl.MatchAllQueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain a specific prefix in a provided field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> Prefix(Elastic.Clients.Elasticsearch.QueryDsl.PrefixQuery? value)
	{
		Instance.Prefix = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain a specific prefix in a provided field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> Prefix(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor<TDocument>> action)
	{
		Instance.Prefix = Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain terms within a provided range.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> Range(Elastic.Clients.Elasticsearch.QueryDsl.IRangeQuery? value)
	{
		Instance.Range = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain terms within a provided range.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> Range(System.Func<Elastic.Clients.Elasticsearch.QueryDsl.IRangeQueryFactory<TDocument>, Elastic.Clients.Elasticsearch.QueryDsl.IRangeQuery> action)
	{
		Instance.Range = Elastic.Clients.Elasticsearch.QueryDsl.IRangeQueryFactory<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users based on a provided query string, using a parser with a limited but fault-tolerant syntax.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> SimpleQueryString(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQuery? value)
	{
		Instance.SimpleQueryString = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users based on a provided query string, using a parser with a limited but fault-tolerant syntax.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> SimpleQueryString(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<TDocument>> action)
	{
		Instance.SimpleQueryString = Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain an exact term in a provided field.
	/// To return a document, the query term must exactly match the queried field's value, including whitespace and capitalization.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> Term(Elastic.Clients.Elasticsearch.QueryDsl.TermQuery? value)
	{
		Instance.Term = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain an exact term in a provided field.
	/// To return a document, the query term must exactly match the queried field's value, including whitespace and capitalization.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> Term(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.TermQueryDescriptor<TDocument>> action)
	{
		Instance.Term = Elastic.Clients.Elasticsearch.QueryDsl.TermQueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain one or more exact terms in a provided field.
	/// To return a document, one or more terms must exactly match a field value, including whitespace and capitalization.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> Terms(Elastic.Clients.Elasticsearch.QueryDsl.TermsQuery? value)
	{
		Instance.Terms = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain one or more exact terms in a provided field.
	/// To return a document, one or more terms must exactly match a field value, including whitespace and capitalization.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> Terms(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor<TDocument>> action)
	{
		Instance.Terms = Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain terms matching a wildcard pattern.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> Wildcard(Elastic.Clients.Elasticsearch.QueryDsl.WildcardQuery? value)
	{
		Instance.Wildcard = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain terms matching a wildcard pattern.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument> Wildcard(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.WildcardQueryDescriptor<TDocument>> action)
	{
		Instance.Wildcard = Elastic.Clients.Elasticsearch.QueryDsl.WildcardQueryDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.UserQuery Build(System.Action<Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Security.UserQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct UserQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.UserQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UserQueryDescriptor(Elastic.Clients.Elasticsearch.Security.UserQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UserQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.UserQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor(Elastic.Clients.Elasticsearch.Security.UserQuery instance) => new Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.UserQuery(Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// matches users matching boolean combinations of other queries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Bool(Elastic.Clients.Elasticsearch.QueryDsl.BoolQuery? value)
	{
		Instance.Bool = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// matches users matching boolean combinations of other queries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Bool()
	{
		Instance.Bool = Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// matches users matching boolean combinations of other queries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Bool(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor>? action)
	{
		Instance.Bool = Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// matches users matching boolean combinations of other queries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Bool<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<T>>? action)
	{
		Instance.Bool = Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain an indexed value for a field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Exists(Elastic.Clients.Elasticsearch.QueryDsl.ExistsQuery? value)
	{
		Instance.Exists = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain an indexed value for a field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Exists(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.ExistsQueryDescriptor> action)
	{
		Instance.Exists = Elastic.Clients.Elasticsearch.QueryDsl.ExistsQueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain an indexed value for a field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Exists<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.ExistsQueryDescriptor<T>> action)
	{
		Instance.Exists = Elastic.Clients.Elasticsearch.QueryDsl.ExistsQueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users based on their IDs.
	/// This query uses the user document IDs stored in the <c>_id</c> field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Ids(Elastic.Clients.Elasticsearch.QueryDsl.IdsQuery? value)
	{
		Instance.Ids = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users based on their IDs.
	/// This query uses the user document IDs stored in the <c>_id</c> field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Ids()
	{
		Instance.Ids = Elastic.Clients.Elasticsearch.QueryDsl.IdsQueryDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users based on their IDs.
	/// This query uses the user document IDs stored in the <c>_id</c> field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Ids(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.IdsQueryDescriptor>? action)
	{
		Instance.Ids = Elastic.Clients.Elasticsearch.QueryDsl.IdsQueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that match a provided text, number, date or boolean value.
	/// The provided text is analyzed before matching.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Match(Elastic.Clients.Elasticsearch.QueryDsl.MatchQuery? value)
	{
		Instance.Match = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that match a provided text, number, date or boolean value.
	/// The provided text is analyzed before matching.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Match(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.MatchQueryDescriptor> action)
	{
		Instance.Match = Elastic.Clients.Elasticsearch.QueryDsl.MatchQueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that match a provided text, number, date or boolean value.
	/// The provided text is analyzed before matching.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Match<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.MatchQueryDescriptor<T>> action)
	{
		Instance.Match = Elastic.Clients.Elasticsearch.QueryDsl.MatchQueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Matches all users, giving them all a <c>_score</c> of 1.0.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor MatchAll(Elastic.Clients.Elasticsearch.QueryDsl.MatchAllQuery? value)
	{
		Instance.MatchAll = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Matches all users, giving them all a <c>_score</c> of 1.0.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor MatchAll()
	{
		Instance.MatchAll = Elastic.Clients.Elasticsearch.QueryDsl.MatchAllQueryDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Matches all users, giving them all a <c>_score</c> of 1.0.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor MatchAll(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.MatchAllQueryDescriptor>? action)
	{
		Instance.MatchAll = Elastic.Clients.Elasticsearch.QueryDsl.MatchAllQueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain a specific prefix in a provided field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Prefix(Elastic.Clients.Elasticsearch.QueryDsl.PrefixQuery? value)
	{
		Instance.Prefix = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain a specific prefix in a provided field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Prefix(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor> action)
	{
		Instance.Prefix = Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain a specific prefix in a provided field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Prefix<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor<T>> action)
	{
		Instance.Prefix = Elastic.Clients.Elasticsearch.QueryDsl.PrefixQueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain terms within a provided range.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Range(Elastic.Clients.Elasticsearch.QueryDsl.IRangeQuery? value)
	{
		Instance.Range = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain terms within a provided range.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Range(System.Func<Elastic.Clients.Elasticsearch.QueryDsl.IRangeQueryFactory, Elastic.Clients.Elasticsearch.QueryDsl.IRangeQuery> action)
	{
		Instance.Range = Elastic.Clients.Elasticsearch.QueryDsl.IRangeQueryFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain terms within a provided range.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Range<T>(System.Func<Elastic.Clients.Elasticsearch.QueryDsl.IRangeQueryFactory<T>, Elastic.Clients.Elasticsearch.QueryDsl.IRangeQuery> action)
	{
		Instance.Range = Elastic.Clients.Elasticsearch.QueryDsl.IRangeQueryFactory<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users based on a provided query string, using a parser with a limited but fault-tolerant syntax.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor SimpleQueryString(Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQuery? value)
	{
		Instance.SimpleQueryString = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users based on a provided query string, using a parser with a limited but fault-tolerant syntax.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor SimpleQueryString(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor> action)
	{
		Instance.SimpleQueryString = Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users based on a provided query string, using a parser with a limited but fault-tolerant syntax.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor SimpleQueryString<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<T>> action)
	{
		Instance.SimpleQueryString = Elastic.Clients.Elasticsearch.QueryDsl.SimpleQueryStringQueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain an exact term in a provided field.
	/// To return a document, the query term must exactly match the queried field's value, including whitespace and capitalization.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Term(Elastic.Clients.Elasticsearch.QueryDsl.TermQuery? value)
	{
		Instance.Term = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain an exact term in a provided field.
	/// To return a document, the query term must exactly match the queried field's value, including whitespace and capitalization.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Term(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.TermQueryDescriptor> action)
	{
		Instance.Term = Elastic.Clients.Elasticsearch.QueryDsl.TermQueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain an exact term in a provided field.
	/// To return a document, the query term must exactly match the queried field's value, including whitespace and capitalization.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Term<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.TermQueryDescriptor<T>> action)
	{
		Instance.Term = Elastic.Clients.Elasticsearch.QueryDsl.TermQueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain one or more exact terms in a provided field.
	/// To return a document, one or more terms must exactly match a field value, including whitespace and capitalization.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Terms(Elastic.Clients.Elasticsearch.QueryDsl.TermsQuery? value)
	{
		Instance.Terms = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain one or more exact terms in a provided field.
	/// To return a document, one or more terms must exactly match a field value, including whitespace and capitalization.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Terms(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor> action)
	{
		Instance.Terms = Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain one or more exact terms in a provided field.
	/// To return a document, one or more terms must exactly match a field value, including whitespace and capitalization.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Terms<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor<T>> action)
	{
		Instance.Terms = Elastic.Clients.Elasticsearch.QueryDsl.TermsQueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain terms matching a wildcard pattern.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Wildcard(Elastic.Clients.Elasticsearch.QueryDsl.WildcardQuery? value)
	{
		Instance.Wildcard = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain terms matching a wildcard pattern.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Wildcard(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.WildcardQueryDescriptor> action)
	{
		Instance.Wildcard = Elastic.Clients.Elasticsearch.QueryDsl.WildcardQueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns users that contain terms matching a wildcard pattern.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor Wildcard<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.WildcardQueryDescriptor<T>> action)
	{
		Instance.Wildcard = Elastic.Clients.Elasticsearch.QueryDsl.WildcardQueryDescriptor<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.UserQuery Build(System.Action<Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UserQueryDescriptor(new Elastic.Clients.Elasticsearch.Security.UserQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}