// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.SearchAccessConverter))]
public sealed partial class SearchAccess
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SearchAccess(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.IndexName> names)
	{
		Names = names;
	}
#if NET7_0_OR_GREATER
	public SearchAccess()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public SearchAccess()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SearchAccess(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Set to <c>true</c> if using wildcard or regular expressions for patterns that cover restricted indices. Implicitly, restricted indices have limited privileges that can cause pattern tests to fail. If restricted indices are explicitly included in the <c>names</c> list, Elasticsearch checks privileges against these indices regardless of the value set for <c>allow_restricted_indices</c>.
	/// </para>
	/// </summary>
	public bool? AllowRestrictedIndices { get; set; }

	/// <summary>
	/// <para>
	/// The document fields that the owners of the role have read access to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.FieldSecurity? FieldSecurity { get; set; }

	/// <summary>
	/// <para>
	/// A list of indices (or index name patterns) to which the permissions in this entry apply.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.IndexName> Names { get; set; }

	/// <summary>
	/// <para>
	/// A search query that defines the documents the owners of the role have access to. A document within the specified indices must match this query for it to be accessible by the owners of the role.
	/// </para>
	/// </summary>
	public object? Query { get; set; }
}

public readonly partial struct SearchAccessDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Security.SearchAccess Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SearchAccessDescriptor(Elastic.Clients.Elasticsearch.Security.SearchAccess instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SearchAccessDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.SearchAccess(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Security.SearchAccess instance) => new Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.SearchAccess(Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Set to <c>true</c> if using wildcard or regular expressions for patterns that cover restricted indices. Implicitly, restricted indices have limited privileges that can cause pattern tests to fail. If restricted indices are explicitly included in the <c>names</c> list, Elasticsearch checks privileges against these indices regardless of the value set for <c>allow_restricted_indices</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor<TDocument> AllowRestrictedIndices(bool? value = true)
	{
		Instance.AllowRestrictedIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The document fields that the owners of the role have read access to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor<TDocument> FieldSecurity(Elastic.Clients.Elasticsearch.Security.FieldSecurity? value)
	{
		Instance.FieldSecurity = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The document fields that the owners of the role have read access to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor<TDocument> FieldSecurity()
	{
		Instance.FieldSecurity = Elastic.Clients.Elasticsearch.Security.FieldSecurityDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The document fields that the owners of the role have read access to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor<TDocument> FieldSecurity(System.Action<Elastic.Clients.Elasticsearch.Security.FieldSecurityDescriptor<TDocument>>? action)
	{
		Instance.FieldSecurity = Elastic.Clients.Elasticsearch.Security.FieldSecurityDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices (or index name patterns) to which the permissions in this entry apply.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor<TDocument> Names(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.IndexName> value)
	{
		Instance.Names = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices (or index name patterns) to which the permissions in this entry apply.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor<TDocument> Names(params Elastic.Clients.Elasticsearch.IndexName[] values)
	{
		Instance.Names = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A search query that defines the documents the owners of the role have access to. A document within the specified indices must match this query for it to be accessible by the owners of the role.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor<TDocument> Query(object? value)
	{
		Instance.Query = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.SearchAccess Build(System.Action<Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Security.SearchAccess(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct SearchAccessDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.SearchAccess Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SearchAccessDescriptor(Elastic.Clients.Elasticsearch.Security.SearchAccess instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SearchAccessDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.SearchAccess(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor(Elastic.Clients.Elasticsearch.Security.SearchAccess instance) => new Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.SearchAccess(Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Set to <c>true</c> if using wildcard or regular expressions for patterns that cover restricted indices. Implicitly, restricted indices have limited privileges that can cause pattern tests to fail. If restricted indices are explicitly included in the <c>names</c> list, Elasticsearch checks privileges against these indices regardless of the value set for <c>allow_restricted_indices</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor AllowRestrictedIndices(bool? value = true)
	{
		Instance.AllowRestrictedIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The document fields that the owners of the role have read access to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor FieldSecurity(Elastic.Clients.Elasticsearch.Security.FieldSecurity? value)
	{
		Instance.FieldSecurity = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The document fields that the owners of the role have read access to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor FieldSecurity()
	{
		Instance.FieldSecurity = Elastic.Clients.Elasticsearch.Security.FieldSecurityDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The document fields that the owners of the role have read access to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor FieldSecurity(System.Action<Elastic.Clients.Elasticsearch.Security.FieldSecurityDescriptor>? action)
	{
		Instance.FieldSecurity = Elastic.Clients.Elasticsearch.Security.FieldSecurityDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The document fields that the owners of the role have read access to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor FieldSecurity<T>(System.Action<Elastic.Clients.Elasticsearch.Security.FieldSecurityDescriptor<T>>? action)
	{
		Instance.FieldSecurity = Elastic.Clients.Elasticsearch.Security.FieldSecurityDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices (or index name patterns) to which the permissions in this entry apply.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor Names(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.IndexName> value)
	{
		Instance.Names = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices (or index name patterns) to which the permissions in this entry apply.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor Names(params Elastic.Clients.Elasticsearch.IndexName[] values)
	{
		Instance.Names = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A search query that defines the documents the owners of the role have access to. A document within the specified indices must match this query for it to be accessible by the owners of the role.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor Query(object? value)
	{
		Instance.Query = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.SearchAccess Build(System.Action<Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SearchAccessDescriptor(new Elastic.Clients.Elasticsearch.Security.SearchAccess(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}