// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.RoleMappingRuleConverter))]
public sealed partial class RoleMappingRule
{
	internal string? VariantType { get; set; }
	internal object? Variant { get; set; }
#if NET7_0_OR_GREATER
	public RoleMappingRule()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public RoleMappingRule()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RoleMappingRule(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>? All { get => GetVariant<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>>("all"); set => SetVariant("all", value); }
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>? Any { get => GetVariant<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>>("any"); set => SetVariant("any", value); }
	public Elastic.Clients.Elasticsearch.Security.RoleMappingRule? Except { get => GetVariant<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>("except"); set => SetVariant("except", value); }
	public System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>>? Field { get => GetVariant<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>>>("field"); set => SetVariant("field", value); }

	public static implicit operator Elastic.Clients.Elasticsearch.Security.RoleMappingRule(System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>> value) => new Elastic.Clients.Elasticsearch.Security.RoleMappingRule { Field = value };

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private T? GetVariant<T>(string type)
	{
		if (string.Equals(VariantType, type, System.StringComparison.Ordinal) && Variant is T result)
		{
			return result;
		}

		return default;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private void SetVariant<T>(string type, T? value)
	{
		VariantType = type;
		Variant = value;
	}
}

public readonly partial struct RoleMappingRuleDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Security.RoleMappingRule Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RoleMappingRuleDescriptor(Elastic.Clients.Elasticsearch.Security.RoleMappingRule instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RoleMappingRuleDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.RoleMappingRule(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Security.RoleMappingRule instance) => new Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.RoleMappingRule(Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument> descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument> All(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>? value)
	{
		Instance.All = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument> All(params Elastic.Clients.Elasticsearch.Security.RoleMappingRule[] values)
	{
		Instance.All = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument> All(params System.Action<Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument>.Build(action));
		}

		Instance.All = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument> Any(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>? value)
	{
		Instance.Any = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument> Any(params Elastic.Clients.Elasticsearch.Security.RoleMappingRule[] values)
	{
		Instance.Any = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument> Any(params System.Action<Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument>.Build(action));
		}

		Instance.Any = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument> Except(Elastic.Clients.Elasticsearch.Security.RoleMappingRule? value)
	{
		Instance.Except = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument> Except(System.Action<Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument>> action)
	{
		Instance.Except = Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument> Field(System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>>? value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field key, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue> value)
	{
		Instance.Field = new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>>(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue> value)
	{
		Instance.Field = new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>>(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field key, params Elastic.Clients.Elasticsearch.FieldValue[] values)
	{
		Instance.Field = new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>>(key, [.. values]);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, params Elastic.Clients.Elasticsearch.FieldValue[] values)
	{
		Instance.Field = new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>>(key, [.. values]);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.RoleMappingRule Build(System.Action<Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Security.RoleMappingRule(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct RoleMappingRuleDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.RoleMappingRule Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RoleMappingRuleDescriptor(Elastic.Clients.Elasticsearch.Security.RoleMappingRule instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RoleMappingRuleDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.RoleMappingRule(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor(Elastic.Clients.Elasticsearch.Security.RoleMappingRule instance) => new Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.RoleMappingRule(Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor All(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>? value)
	{
		Instance.All = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor All(params Elastic.Clients.Elasticsearch.Security.RoleMappingRule[] values)
	{
		Instance.All = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor All(params System.Action<Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor.Build(action));
		}

		Instance.All = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor All<T>(params System.Action<Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<T>.Build(action));
		}

		Instance.All = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor Any(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>? value)
	{
		Instance.Any = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor Any(params Elastic.Clients.Elasticsearch.Security.RoleMappingRule[] values)
	{
		Instance.Any = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor Any(params System.Action<Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor.Build(action));
		}

		Instance.Any = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor Any<T>(params System.Action<Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<T>.Build(action));
		}

		Instance.Any = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor Except(Elastic.Clients.Elasticsearch.Security.RoleMappingRule? value)
	{
		Instance.Except = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor Except(System.Action<Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor> action)
	{
		Instance.Except = Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor Except<T>(System.Action<Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<T>> action)
	{
		Instance.Except = Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor Field(System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>>? value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor Field(Elastic.Clients.Elasticsearch.Field key, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue> value)
	{
		Instance.Field = new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>>(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue> value)
	{
		Instance.Field = new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>>(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor Field(Elastic.Clients.Elasticsearch.Field key, params Elastic.Clients.Elasticsearch.FieldValue[] values)
	{
		Instance.Field = new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>>(key, [.. values]);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, params Elastic.Clients.Elasticsearch.FieldValue[] values)
	{
		Instance.Field = new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>>(key, [.. values]);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.RoleMappingRule Build(System.Action<Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor(new Elastic.Clients.Elasticsearch.Security.RoleMappingRule(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}