// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security.Json;

public sealed partial class RoleMappingRuleConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>
{
	private static readonly System.Text.Json.JsonEncodedText VariantAll = System.Text.Json.JsonEncodedText.Encode("all");
	private static readonly System.Text.Json.JsonEncodedText VariantAny = System.Text.Json.JsonEncodedText.Encode("any");
	private static readonly System.Text.Json.JsonEncodedText VariantExcept = System.Text.Json.JsonEncodedText.Encode("except");
	private static readonly System.Text.Json.JsonEncodedText VariantField = System.Text.Json.JsonEncodedText.Encode("field");

	public override Elastic.Clients.Elasticsearch.Security.RoleMappingRule Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		string? variantType = null;
		object? variant = null;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (reader.ValueTextEquals(VariantAll))
			{
				variantType = VariantAll.Value;
				reader.Read();
				variant = reader.ReadValue<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>>(options, static System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RoleMappingRule> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>(o, null)!);
				continue;
			}

			if (reader.ValueTextEquals(VariantAny))
			{
				variantType = VariantAny.Value;
				reader.Read();
				variant = reader.ReadValue<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>>(options, static System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RoleMappingRule> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>(o, null)!);
				continue;
			}

			if (reader.ValueTextEquals(VariantExcept))
			{
				variantType = VariantExcept.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantField))
			{
				variantType = VariantField.Value;
				reader.Read();
				variant = reader.ReadValue<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>>>(options, static System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadKeyValuePairValue<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>>(o, null, static System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadSingleOrManyCollectionValue<Elastic.Clients.Elasticsearch.FieldValue>(o, null)!));
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Security.RoleMappingRule(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			VariantType = variantType,
			Variant = variant
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Security.RoleMappingRule value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		switch (value.VariantType)
		{
			case null:
				break;
			case "all":
				writer.WriteProperty(options, value.VariantType, (System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>)value.Variant, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RoleMappingRule> v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>(o, v, null));
				break;
			case "any":
				writer.WriteProperty(options, value.VariantType, (System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>)value.Variant, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RoleMappingRule> v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Security.RoleMappingRule>(o, v, null));
				break;
			case "except":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Security.RoleMappingRule)value.Variant, null, null);
				break;
			case "field":
				writer.WriteProperty(options, value.VariantType, (System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>>)value.Variant, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>> v) => w.WriteKeyValuePairValue<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>>(o, v, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue> v) => w.WriteSingleOrManyCollectionValue<Elastic.Clients.Elasticsearch.FieldValue>(o, v, null)));
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.VariantType}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.Security.RoleMappingRule)}'.");
		}

		writer.WriteEndObject();
	}
}