// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.RoleDescriptorConverter))]
public sealed partial class RoleDescriptor
{
#if NET7_0_OR_GREATER
	public RoleDescriptor()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public RoleDescriptor()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RoleDescriptor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A list of application privilege entries
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.ApplicationPrivileges>? Applications { get; set; }

	/// <summary>
	/// <para>
	/// A list of cluster privileges. These privileges define the cluster level actions that API keys are able to execute.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.ClusterPrivilege>? Cluster { get; set; }

	/// <summary>
	/// <para>
	/// Optional description of the role descriptor
	/// </para>
	/// </summary>
	public string? Description { get; set; }

	/// <summary>
	/// <para>
	/// An object defining global privileges. A global privilege is a form of cluster privilege that is request-aware. Support for global privileges is currently limited to the management of application privileges.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.GlobalPrivilege>? Global { get; set; }

	/// <summary>
	/// <para>
	/// A list of indices permissions entries.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.IndicesPrivileges>? Indices { get; set; }

	/// <summary>
	/// <para>
	/// Optional meta-data. Within the metadata object, keys that begin with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Metadata { get; set; }

	/// <summary>
	/// <para>
	/// A list of cluster permissions for remote clusters.
	/// NOTE: This is limited a subset of the cluster permissions.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivileges>? RemoteCluster { get; set; }

	/// <summary>
	/// <para>
	/// A list of indices permissions for remote clusters.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges>? RemoteIndices { get; set; }

	/// <summary>
	/// <para>
	/// Restriction for when the role descriptor is allowed to be effective.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.Restriction? Restriction { get; set; }

	/// <summary>
	/// <para>
	/// A list of users that the API keys can impersonate.
	/// NOTE: In Elastic Cloud Serverless, the run-as feature is disabled.
	/// For API compatibility, you can still specify an empty <c>run_as</c> field, but a non-empty list will be rejected.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? RunAs { get; set; }
	public System.Collections.Generic.IDictionary<string, object>? TransientMetadata { get; set; }
}

public readonly partial struct RoleDescriptorDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Security.RoleDescriptor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RoleDescriptorDescriptor(Elastic.Clients.Elasticsearch.Security.RoleDescriptor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RoleDescriptorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.RoleDescriptor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Security.RoleDescriptor instance) => new Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.RoleDescriptor(Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A list of application privilege entries
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> Applications(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.ApplicationPrivileges>? value)
	{
		Instance.Applications = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of application privilege entries
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> Applications(params Elastic.Clients.Elasticsearch.Security.ApplicationPrivileges[] values)
	{
		Instance.Applications = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of application privilege entries
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> Applications(params System.Action<Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.ApplicationPrivileges>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesDescriptor.Build(action));
		}

		Instance.Applications = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of cluster privileges. These privileges define the cluster level actions that API keys are able to execute.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> Cluster(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.ClusterPrivilege>? value)
	{
		Instance.Cluster = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of cluster privileges. These privileges define the cluster level actions that API keys are able to execute.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> Cluster(params Elastic.Clients.Elasticsearch.Security.ClusterPrivilege[] values)
	{
		Instance.Cluster = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional description of the role descriptor
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An object defining global privileges. A global privilege is a form of cluster privilege that is request-aware. Support for global privileges is currently limited to the management of application privileges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> Global(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.GlobalPrivilege>? value)
	{
		Instance.Global = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An object defining global privileges. A global privilege is a form of cluster privilege that is request-aware. Support for global privileges is currently limited to the management of application privileges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> Global(params Elastic.Clients.Elasticsearch.Security.GlobalPrivilege[] values)
	{
		Instance.Global = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An object defining global privileges. A global privilege is a form of cluster privilege that is request-aware. Support for global privileges is currently limited to the management of application privileges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> Global(params System.Action<Elastic.Clients.Elasticsearch.Security.GlobalPrivilegeDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.GlobalPrivilege>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.GlobalPrivilegeDescriptor.Build(action));
		}

		Instance.Global = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices permissions entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> Indices(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.IndicesPrivileges>? value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices permissions entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> Indices(params Elastic.Clients.Elasticsearch.Security.IndicesPrivileges[] values)
	{
		Instance.Indices = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices permissions entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> Indices(params System.Action<Elastic.Clients.Elasticsearch.Security.IndicesPrivilegesDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.IndicesPrivileges>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.IndicesPrivilegesDescriptor<TDocument>.Build(action));
		}

		Instance.Indices = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional meta-data. Within the metadata object, keys that begin with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> Metadata(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Metadata = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional meta-data. Within the metadata object, keys that begin with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> Metadata()
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional meta-data. Within the metadata object, keys that begin with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> Metadata(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> AddMetadatum(string key, object value)
	{
		Instance.Metadata ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Metadata.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of cluster permissions for remote clusters.
	/// NOTE: This is limited a subset of the cluster permissions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> RemoteCluster(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivileges>? value)
	{
		Instance.RemoteCluster = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of cluster permissions for remote clusters.
	/// NOTE: This is limited a subset of the cluster permissions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> RemoteCluster(params Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivileges[] values)
	{
		Instance.RemoteCluster = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of cluster permissions for remote clusters.
	/// NOTE: This is limited a subset of the cluster permissions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> RemoteCluster(params System.Action<Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilegesDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivileges>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilegesDescriptor.Build(action));
		}

		Instance.RemoteCluster = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices permissions for remote clusters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> RemoteIndices(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges>? value)
	{
		Instance.RemoteIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices permissions for remote clusters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> RemoteIndices(params Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges[] values)
	{
		Instance.RemoteIndices = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices permissions for remote clusters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> RemoteIndices(params System.Action<Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor<TDocument>.Build(action));
		}

		Instance.RemoteIndices = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Restriction for when the role descriptor is allowed to be effective.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> Restriction(Elastic.Clients.Elasticsearch.Security.Restriction? value)
	{
		Instance.Restriction = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Restriction for when the role descriptor is allowed to be effective.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> Restriction(System.Action<Elastic.Clients.Elasticsearch.Security.RestrictionDescriptor> action)
	{
		Instance.Restriction = Elastic.Clients.Elasticsearch.Security.RestrictionDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of users that the API keys can impersonate.
	/// NOTE: In Elastic Cloud Serverless, the run-as feature is disabled.
	/// For API compatibility, you can still specify an empty <c>run_as</c> field, but a non-empty list will be rejected.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> RunAs(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.RunAs = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of users that the API keys can impersonate.
	/// NOTE: In Elastic Cloud Serverless, the run-as feature is disabled.
	/// For API compatibility, you can still specify an empty <c>run_as</c> field, but a non-empty list will be rejected.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> RunAs(params string[] values)
	{
		Instance.RunAs = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> TransientMetadata(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.TransientMetadata = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> TransientMetadata()
	{
		Instance.TransientMetadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> TransientMetadata(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.TransientMetadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument> AddTransientMetadatum(string key, object value)
	{
		Instance.TransientMetadata ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.TransientMetadata.Add(key, value);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.RoleDescriptor Build(System.Action<Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Security.RoleDescriptor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Security.RoleDescriptor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct RoleDescriptorDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.RoleDescriptor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RoleDescriptorDescriptor(Elastic.Clients.Elasticsearch.Security.RoleDescriptor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RoleDescriptorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.RoleDescriptor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor(Elastic.Clients.Elasticsearch.Security.RoleDescriptor instance) => new Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.RoleDescriptor(Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A list of application privilege entries
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor Applications(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.ApplicationPrivileges>? value)
	{
		Instance.Applications = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of application privilege entries
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor Applications(params Elastic.Clients.Elasticsearch.Security.ApplicationPrivileges[] values)
	{
		Instance.Applications = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of application privilege entries
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor Applications(params System.Action<Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.ApplicationPrivileges>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesDescriptor.Build(action));
		}

		Instance.Applications = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of cluster privileges. These privileges define the cluster level actions that API keys are able to execute.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor Cluster(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.ClusterPrivilege>? value)
	{
		Instance.Cluster = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of cluster privileges. These privileges define the cluster level actions that API keys are able to execute.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor Cluster(params Elastic.Clients.Elasticsearch.Security.ClusterPrivilege[] values)
	{
		Instance.Cluster = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional description of the role descriptor
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An object defining global privileges. A global privilege is a form of cluster privilege that is request-aware. Support for global privileges is currently limited to the management of application privileges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor Global(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.GlobalPrivilege>? value)
	{
		Instance.Global = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An object defining global privileges. A global privilege is a form of cluster privilege that is request-aware. Support for global privileges is currently limited to the management of application privileges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor Global(params Elastic.Clients.Elasticsearch.Security.GlobalPrivilege[] values)
	{
		Instance.Global = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An object defining global privileges. A global privilege is a form of cluster privilege that is request-aware. Support for global privileges is currently limited to the management of application privileges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor Global(params System.Action<Elastic.Clients.Elasticsearch.Security.GlobalPrivilegeDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.GlobalPrivilege>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.GlobalPrivilegeDescriptor.Build(action));
		}

		Instance.Global = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices permissions entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor Indices(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.IndicesPrivileges>? value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices permissions entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor Indices(params Elastic.Clients.Elasticsearch.Security.IndicesPrivileges[] values)
	{
		Instance.Indices = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices permissions entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor Indices(params System.Action<Elastic.Clients.Elasticsearch.Security.IndicesPrivilegesDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.IndicesPrivileges>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.IndicesPrivilegesDescriptor.Build(action));
		}

		Instance.Indices = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices permissions entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor Indices<T>(params System.Action<Elastic.Clients.Elasticsearch.Security.IndicesPrivilegesDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.IndicesPrivileges>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.IndicesPrivilegesDescriptor<T>.Build(action));
		}

		Instance.Indices = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional meta-data. Within the metadata object, keys that begin with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor Metadata(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Metadata = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional meta-data. Within the metadata object, keys that begin with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor Metadata()
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional meta-data. Within the metadata object, keys that begin with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor Metadata(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor AddMetadatum(string key, object value)
	{
		Instance.Metadata ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Metadata.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of cluster permissions for remote clusters.
	/// NOTE: This is limited a subset of the cluster permissions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor RemoteCluster(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivileges>? value)
	{
		Instance.RemoteCluster = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of cluster permissions for remote clusters.
	/// NOTE: This is limited a subset of the cluster permissions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor RemoteCluster(params Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivileges[] values)
	{
		Instance.RemoteCluster = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of cluster permissions for remote clusters.
	/// NOTE: This is limited a subset of the cluster permissions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor RemoteCluster(params System.Action<Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilegesDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivileges>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilegesDescriptor.Build(action));
		}

		Instance.RemoteCluster = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices permissions for remote clusters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor RemoteIndices(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges>? value)
	{
		Instance.RemoteIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices permissions for remote clusters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor RemoteIndices(params Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges[] values)
	{
		Instance.RemoteIndices = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices permissions for remote clusters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor RemoteIndices(params System.Action<Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor.Build(action));
		}

		Instance.RemoteIndices = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices permissions for remote clusters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor RemoteIndices<T>(params System.Action<Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor<T>.Build(action));
		}

		Instance.RemoteIndices = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Restriction for when the role descriptor is allowed to be effective.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor Restriction(Elastic.Clients.Elasticsearch.Security.Restriction? value)
	{
		Instance.Restriction = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Restriction for when the role descriptor is allowed to be effective.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor Restriction(System.Action<Elastic.Clients.Elasticsearch.Security.RestrictionDescriptor> action)
	{
		Instance.Restriction = Elastic.Clients.Elasticsearch.Security.RestrictionDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of users that the API keys can impersonate.
	/// NOTE: In Elastic Cloud Serverless, the run-as feature is disabled.
	/// For API compatibility, you can still specify an empty <c>run_as</c> field, but a non-empty list will be rejected.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor RunAs(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.RunAs = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of users that the API keys can impersonate.
	/// NOTE: In Elastic Cloud Serverless, the run-as feature is disabled.
	/// For API compatibility, you can still specify an empty <c>run_as</c> field, but a non-empty list will be rejected.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor RunAs(params string[] values)
	{
		Instance.RunAs = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor TransientMetadata(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.TransientMetadata = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor TransientMetadata()
	{
		Instance.TransientMetadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor TransientMetadata(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.TransientMetadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor AddTransientMetadatum(string key, object value)
	{
		Instance.TransientMetadata ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.TransientMetadata.Add(key, value);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.RoleDescriptor Build(System.Action<Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Security.RoleDescriptor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor(new Elastic.Clients.Elasticsearch.Security.RoleDescriptor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}