// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.RestrictionConverter))]
public sealed partial class Restriction
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public Restriction(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RestrictionWorkflow> workflows)
	{
		Workflows = workflows;
	}
#if NET7_0_OR_GREATER
	public Restriction()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public Restriction()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Restriction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A list of workflows to which the API key is restricted.
	/// NOTE: In order to use a role restriction, an API key must be created with a single role descriptor.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RestrictionWorkflow> Workflows { get; set; }
}

public readonly partial struct RestrictionDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.Restriction Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RestrictionDescriptor(Elastic.Clients.Elasticsearch.Security.Restriction instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RestrictionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.Restriction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.RestrictionDescriptor(Elastic.Clients.Elasticsearch.Security.Restriction instance) => new Elastic.Clients.Elasticsearch.Security.RestrictionDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.Restriction(Elastic.Clients.Elasticsearch.Security.RestrictionDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A list of workflows to which the API key is restricted.
	/// NOTE: In order to use a role restriction, an API key must be created with a single role descriptor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RestrictionDescriptor Workflows(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RestrictionWorkflow> value)
	{
		Instance.Workflows = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of workflows to which the API key is restricted.
	/// NOTE: In order to use a role restriction, an API key must be created with a single role descriptor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RestrictionDescriptor Workflows(params Elastic.Clients.Elasticsearch.Security.RestrictionWorkflow[] values)
	{
		Instance.Workflows = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.Restriction Build(System.Action<Elastic.Clients.Elasticsearch.Security.RestrictionDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.RestrictionDescriptor(new Elastic.Clients.Elasticsearch.Security.Restriction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}