// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.ReplicationAccessConverter))]
public sealed partial class ReplicationAccess
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ReplicationAccess(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.IndexName> names)
	{
		Names = names;
	}
#if NET7_0_OR_GREATER
	public ReplicationAccess()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ReplicationAccess()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ReplicationAccess(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// This needs to be set to true if the patterns in the names field should cover system indices.
	/// </para>
	/// </summary>
	public bool? AllowRestrictedIndices { get; set; }

	/// <summary>
	/// <para>
	/// A list of indices (or index name patterns) to which the permissions in this entry apply.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.IndexName> Names { get; set; }
}

public readonly partial struct ReplicationAccessDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.ReplicationAccess Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ReplicationAccessDescriptor(Elastic.Clients.Elasticsearch.Security.ReplicationAccess instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ReplicationAccessDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.ReplicationAccess(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.ReplicationAccessDescriptor(Elastic.Clients.Elasticsearch.Security.ReplicationAccess instance) => new Elastic.Clients.Elasticsearch.Security.ReplicationAccessDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.ReplicationAccess(Elastic.Clients.Elasticsearch.Security.ReplicationAccessDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// This needs to be set to true if the patterns in the names field should cover system indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ReplicationAccessDescriptor AllowRestrictedIndices(bool? value = true)
	{
		Instance.AllowRestrictedIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices (or index name patterns) to which the permissions in this entry apply.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ReplicationAccessDescriptor Names(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.IndexName> value)
	{
		Instance.Names = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices (or index name patterns) to which the permissions in this entry apply.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ReplicationAccessDescriptor Names(params Elastic.Clients.Elasticsearch.IndexName[] values)
	{
		Instance.Names = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.ReplicationAccess Build(System.Action<Elastic.Clients.Elasticsearch.Security.ReplicationAccessDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ReplicationAccessDescriptor(new Elastic.Clients.Elasticsearch.Security.ReplicationAccess(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}