// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

/// <summary>
/// <para>
/// The subset of index level privileges that can be defined for remote clusters.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.RemoteIndicesPrivilegesConverter))]
public sealed partial class RemoteIndicesPrivileges
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RemoteIndicesPrivileges(Elastic.Clients.Elasticsearch.Names clusters, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.IndexName> names, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.IndexPrivilege> privileges)
	{
		Clusters = clusters;
		Names = names;
		Privileges = privileges;
	}
#if NET7_0_OR_GREATER
	public RemoteIndicesPrivileges()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public RemoteIndicesPrivileges()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RemoteIndicesPrivileges(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Set to <c>true</c> if using wildcard or regular expressions for patterns that cover restricted indices. Implicitly, restricted indices have limited privileges that can cause pattern tests to fail. If restricted indices are explicitly included in the <c>names</c> list, Elasticsearch checks privileges against these indices regardless of the value set for <c>allow_restricted_indices</c>.
	/// </para>
	/// </summary>
	public bool? AllowRestrictedIndices { get; set; }

	/// <summary>
	/// <para>
	/// A list of cluster aliases to which the permissions in this entry apply.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Names Clusters { get; set; }

	/// <summary>
	/// <para>
	/// The document fields that the owners of the role have read access to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.FieldSecurity? FieldSecurity { get; set; }

	/// <summary>
	/// <para>
	/// A list of indices (or index name patterns) to which the permissions in this entry apply.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.IndexName> Names { get; set; }

	/// <summary>
	/// <para>
	/// The index level privileges that owners of the role have on the specified indices.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.IndexPrivilege> Privileges { get; set; }

	/// <summary>
	/// <para>
	/// A search query that defines the documents the owners of the role have access to. A document within the specified indices must match this query for it to be accessible by the owners of the role.
	/// </para>
	/// </summary>
	public object? Query { get; set; }
}

/// <summary>
/// <para>
/// The subset of index level privileges that can be defined for remote clusters.
/// </para>
/// </summary>
public readonly partial struct RemoteIndicesPrivilegesDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RemoteIndicesPrivilegesDescriptor(Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RemoteIndicesPrivilegesDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges instance) => new Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges(Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Set to <c>true</c> if using wildcard or regular expressions for patterns that cover restricted indices. Implicitly, restricted indices have limited privileges that can cause pattern tests to fail. If restricted indices are explicitly included in the <c>names</c> list, Elasticsearch checks privileges against these indices regardless of the value set for <c>allow_restricted_indices</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor<TDocument> AllowRestrictedIndices(bool? value = true)
	{
		Instance.AllowRestrictedIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of cluster aliases to which the permissions in this entry apply.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor<TDocument> Clusters(Elastic.Clients.Elasticsearch.Names value)
	{
		Instance.Clusters = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The document fields that the owners of the role have read access to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor<TDocument> FieldSecurity(Elastic.Clients.Elasticsearch.Security.FieldSecurity? value)
	{
		Instance.FieldSecurity = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The document fields that the owners of the role have read access to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor<TDocument> FieldSecurity()
	{
		Instance.FieldSecurity = Elastic.Clients.Elasticsearch.Security.FieldSecurityDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The document fields that the owners of the role have read access to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor<TDocument> FieldSecurity(System.Action<Elastic.Clients.Elasticsearch.Security.FieldSecurityDescriptor<TDocument>>? action)
	{
		Instance.FieldSecurity = Elastic.Clients.Elasticsearch.Security.FieldSecurityDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices (or index name patterns) to which the permissions in this entry apply.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor<TDocument> Names(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.IndexName> value)
	{
		Instance.Names = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices (or index name patterns) to which the permissions in this entry apply.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor<TDocument> Names(params Elastic.Clients.Elasticsearch.IndexName[] values)
	{
		Instance.Names = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The index level privileges that owners of the role have on the specified indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor<TDocument> Privileges(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.IndexPrivilege> value)
	{
		Instance.Privileges = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The index level privileges that owners of the role have on the specified indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor<TDocument> Privileges(params Elastic.Clients.Elasticsearch.Security.IndexPrivilege[] values)
	{
		Instance.Privileges = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A search query that defines the documents the owners of the role have access to. A document within the specified indices must match this query for it to be accessible by the owners of the role.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor<TDocument> Query(object? value)
	{
		Instance.Query = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges Build(System.Action<Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

/// <summary>
/// <para>
/// The subset of index level privileges that can be defined for remote clusters.
/// </para>
/// </summary>
public readonly partial struct RemoteIndicesPrivilegesDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RemoteIndicesPrivilegesDescriptor(Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RemoteIndicesPrivilegesDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor(Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges instance) => new Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges(Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Set to <c>true</c> if using wildcard or regular expressions for patterns that cover restricted indices. Implicitly, restricted indices have limited privileges that can cause pattern tests to fail. If restricted indices are explicitly included in the <c>names</c> list, Elasticsearch checks privileges against these indices regardless of the value set for <c>allow_restricted_indices</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor AllowRestrictedIndices(bool? value = true)
	{
		Instance.AllowRestrictedIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of cluster aliases to which the permissions in this entry apply.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor Clusters(Elastic.Clients.Elasticsearch.Names value)
	{
		Instance.Clusters = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The document fields that the owners of the role have read access to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor FieldSecurity(Elastic.Clients.Elasticsearch.Security.FieldSecurity? value)
	{
		Instance.FieldSecurity = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The document fields that the owners of the role have read access to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor FieldSecurity()
	{
		Instance.FieldSecurity = Elastic.Clients.Elasticsearch.Security.FieldSecurityDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The document fields that the owners of the role have read access to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor FieldSecurity(System.Action<Elastic.Clients.Elasticsearch.Security.FieldSecurityDescriptor>? action)
	{
		Instance.FieldSecurity = Elastic.Clients.Elasticsearch.Security.FieldSecurityDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The document fields that the owners of the role have read access to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor FieldSecurity<T>(System.Action<Elastic.Clients.Elasticsearch.Security.FieldSecurityDescriptor<T>>? action)
	{
		Instance.FieldSecurity = Elastic.Clients.Elasticsearch.Security.FieldSecurityDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices (or index name patterns) to which the permissions in this entry apply.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor Names(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.IndexName> value)
	{
		Instance.Names = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices (or index name patterns) to which the permissions in this entry apply.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor Names(params Elastic.Clients.Elasticsearch.IndexName[] values)
	{
		Instance.Names = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The index level privileges that owners of the role have on the specified indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor Privileges(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.IndexPrivilege> value)
	{
		Instance.Privileges = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The index level privileges that owners of the role have on the specified indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor Privileges(params Elastic.Clients.Elasticsearch.Security.IndexPrivilege[] values)
	{
		Instance.Privileges = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A search query that defines the documents the owners of the role have access to. A document within the specified indices must match this query for it to be accessible by the owners of the role.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor Query(object? value)
	{
		Instance.Query = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges Build(System.Action<Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor(new Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}