// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

/// <summary>
/// <para>
/// The subset of cluster level privileges that can be defined for remote clusters.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.RemoteClusterPrivilegesConverter))]
public sealed partial class RemoteClusterPrivileges
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RemoteClusterPrivileges(Elastic.Clients.Elasticsearch.Names clusters, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilege> privileges)
	{
		Clusters = clusters;
		Privileges = privileges;
	}
#if NET7_0_OR_GREATER
	public RemoteClusterPrivileges()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public RemoteClusterPrivileges()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RemoteClusterPrivileges(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A list of cluster aliases to which the permissions in this entry apply.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Names Clusters { get; set; }

	/// <summary>
	/// <para>
	/// The cluster level privileges that owners of the role have on the remote cluster.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilege> Privileges { get; set; }
}

/// <summary>
/// <para>
/// The subset of cluster level privileges that can be defined for remote clusters.
/// </para>
/// </summary>
public readonly partial struct RemoteClusterPrivilegesDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivileges Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RemoteClusterPrivilegesDescriptor(Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivileges instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RemoteClusterPrivilegesDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivileges(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilegesDescriptor(Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivileges instance) => new Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilegesDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivileges(Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilegesDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A list of cluster aliases to which the permissions in this entry apply.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilegesDescriptor Clusters(Elastic.Clients.Elasticsearch.Names value)
	{
		Instance.Clusters = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The cluster level privileges that owners of the role have on the remote cluster.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilegesDescriptor Privileges(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilege> value)
	{
		Instance.Privileges = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The cluster level privileges that owners of the role have on the remote cluster.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilegesDescriptor Privileges(params Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilege[] values)
	{
		Instance.Privileges = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivileges Build(System.Action<Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilegesDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilegesDescriptor(new Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivileges(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}