// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security.Json;

public sealed partial class RemoteClusterPrivilegeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilege>
{
	private static readonly System.Text.Json.JsonEncodedText MemberMonitorEnrich = System.Text.Json.JsonEncodedText.Encode("monitor_enrich");
	private static readonly System.Text.Json.JsonEncodedText MemberMonitorStats = System.Text.Json.JsonEncodedText.Encode("monitor_stats");

	public override Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilege Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberMonitorEnrich))
		{
			return Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilege.MonitorEnrich;
		}

		if (reader.ValueTextEquals(MemberMonitorStats))
		{
			return Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilege.MonitorStats;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberMonitorEnrich.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilege.MonitorEnrich;
		}

		if (string.Equals(value, MemberMonitorStats.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilege.MonitorStats;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilege)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilege value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilege.MonitorEnrich:
				writer.WriteStringValue(MemberMonitorEnrich);
				break;
			case Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilege.MonitorStats:
				writer.WriteStringValue(MemberMonitorStats);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilege)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilege ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilege value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}