// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.PrivilegesCheckConverter))]
public sealed partial class PrivilegesCheck
{
#if NET7_0_OR_GREATER
	public PrivilegesCheck()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public PrivilegesCheck()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PrivilegesCheck(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesCheck>? Application { get; set; }

	/// <summary>
	/// <para>
	/// A list of the cluster privileges that you want to check.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.ClusterPrivilege>? Cluster { get; set; }
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.IndexPrivilegesCheck>? Index { get; set; }
}

public readonly partial struct PrivilegesCheckDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.PrivilegesCheck Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PrivilegesCheckDescriptor(Elastic.Clients.Elasticsearch.Security.PrivilegesCheck instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PrivilegesCheckDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.PrivilegesCheck(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.PrivilegesCheckDescriptor(Elastic.Clients.Elasticsearch.Security.PrivilegesCheck instance) => new Elastic.Clients.Elasticsearch.Security.PrivilegesCheckDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.PrivilegesCheck(Elastic.Clients.Elasticsearch.Security.PrivilegesCheckDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Security.PrivilegesCheckDescriptor Application(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesCheck>? value)
	{
		Instance.Application = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PrivilegesCheckDescriptor Application(params Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesCheck[] values)
	{
		Instance.Application = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PrivilegesCheckDescriptor Application(params System.Action<Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesCheckDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesCheck>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesCheckDescriptor.Build(action));
		}

		Instance.Application = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of the cluster privileges that you want to check.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PrivilegesCheckDescriptor Cluster(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.ClusterPrivilege>? value)
	{
		Instance.Cluster = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of the cluster privileges that you want to check.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PrivilegesCheckDescriptor Cluster(params Elastic.Clients.Elasticsearch.Security.ClusterPrivilege[] values)
	{
		Instance.Cluster = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PrivilegesCheckDescriptor Index(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.IndexPrivilegesCheck>? value)
	{
		Instance.Index = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PrivilegesCheckDescriptor Index(params Elastic.Clients.Elasticsearch.Security.IndexPrivilegesCheck[] values)
	{
		Instance.Index = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PrivilegesCheckDescriptor Index(params System.Action<Elastic.Clients.Elasticsearch.Security.IndexPrivilegesCheckDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.IndexPrivilegesCheck>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.IndexPrivilegesCheckDescriptor.Build(action));
		}

		Instance.Index = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.PrivilegesCheck Build(System.Action<Elastic.Clients.Elasticsearch.Security.PrivilegesCheckDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Security.PrivilegesCheck(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Security.PrivilegesCheckDescriptor(new Elastic.Clients.Elasticsearch.Security.PrivilegesCheck(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}