// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.PrivilegeActionsConverter))]
public sealed partial class PrivilegeActions
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PrivilegeActions(System.Collections.Generic.ICollection<string> actions)
	{
		Actions = actions;
	}
#if NET7_0_OR_GREATER
	public PrivilegeActions()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public PrivilegeActions()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PrivilegeActions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<string> Actions { get; set; }
	public string? Application { get; set; }
	public System.Collections.Generic.IDictionary<string, object>? Metadata { get; set; }
	public Elastic.Clients.Elasticsearch.Name? Name { get; set; }
}

public readonly partial struct PrivilegeActionsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.PrivilegeActions Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PrivilegeActionsDescriptor(Elastic.Clients.Elasticsearch.Security.PrivilegeActions instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PrivilegeActionsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.PrivilegeActions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.PrivilegeActionsDescriptor(Elastic.Clients.Elasticsearch.Security.PrivilegeActions instance) => new Elastic.Clients.Elasticsearch.Security.PrivilegeActionsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.PrivilegeActions(Elastic.Clients.Elasticsearch.Security.PrivilegeActionsDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Security.PrivilegeActionsDescriptor Actions(System.Collections.Generic.ICollection<string> value)
	{
		Instance.Actions = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PrivilegeActionsDescriptor Actions(params string[] values)
	{
		Instance.Actions = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PrivilegeActionsDescriptor Application(string? value)
	{
		Instance.Application = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PrivilegeActionsDescriptor Metadata(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Metadata = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PrivilegeActionsDescriptor Metadata()
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PrivilegeActionsDescriptor Metadata(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PrivilegeActionsDescriptor AddMetadatum(string key, object value)
	{
		Instance.Metadata ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Metadata.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PrivilegeActionsDescriptor Name(Elastic.Clients.Elasticsearch.Name? value)
	{
		Instance.Name = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.PrivilegeActions Build(System.Action<Elastic.Clients.Elasticsearch.Security.PrivilegeActionsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.PrivilegeActionsDescriptor(new Elastic.Clients.Elasticsearch.Security.PrivilegeActions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}