// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.IndexPrivilegesCheckConverter))]
public sealed partial class IndexPrivilegesCheck
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexPrivilegesCheck(Elastic.Clients.Elasticsearch.Indices names, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.IndexPrivilege> privileges)
	{
		Names = names;
		Privileges = privileges;
	}
#if NET7_0_OR_GREATER
	public IndexPrivilegesCheck()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public IndexPrivilegesCheck()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IndexPrivilegesCheck(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// This needs to be set to <c>true</c> (default is <c>false</c>) if using wildcards or regexps for patterns that cover restricted indices.
	/// Implicitly, restricted indices do not match index patterns because restricted indices usually have limited privileges and including them in pattern tests would render most such tests false.
	/// If restricted indices are explicitly included in the names list, privileges will be checked against them regardless of the value of <c>allow_restricted_indices</c>.
	/// </para>
	/// </summary>
	public bool? AllowRestrictedIndices { get; set; }

	/// <summary>
	/// <para>
	/// A list of indices.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Indices Names { get; set; }

	/// <summary>
	/// <para>
	/// A list of the privileges that you want to check for the specified indices.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.IndexPrivilege> Privileges { get; set; }
}

public readonly partial struct IndexPrivilegesCheckDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.IndexPrivilegesCheck Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexPrivilegesCheckDescriptor(Elastic.Clients.Elasticsearch.Security.IndexPrivilegesCheck instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexPrivilegesCheckDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.IndexPrivilegesCheck(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.IndexPrivilegesCheckDescriptor(Elastic.Clients.Elasticsearch.Security.IndexPrivilegesCheck instance) => new Elastic.Clients.Elasticsearch.Security.IndexPrivilegesCheckDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.IndexPrivilegesCheck(Elastic.Clients.Elasticsearch.Security.IndexPrivilegesCheckDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// This needs to be set to <c>true</c> (default is <c>false</c>) if using wildcards or regexps for patterns that cover restricted indices.
	/// Implicitly, restricted indices do not match index patterns because restricted indices usually have limited privileges and including them in pattern tests would render most such tests false.
	/// If restricted indices are explicitly included in the names list, privileges will be checked against them regardless of the value of <c>allow_restricted_indices</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.IndexPrivilegesCheckDescriptor AllowRestrictedIndices(bool? value = true)
	{
		Instance.AllowRestrictedIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.IndexPrivilegesCheckDescriptor Names(Elastic.Clients.Elasticsearch.Indices value)
	{
		Instance.Names = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of the privileges that you want to check for the specified indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.IndexPrivilegesCheckDescriptor Privileges(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.IndexPrivilege> value)
	{
		Instance.Privileges = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of the privileges that you want to check for the specified indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.IndexPrivilegesCheckDescriptor Privileges(params Elastic.Clients.Elasticsearch.Security.IndexPrivilege[] values)
	{
		Instance.Privileges = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.IndexPrivilegesCheck Build(System.Action<Elastic.Clients.Elasticsearch.Security.IndexPrivilegesCheckDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.IndexPrivilegesCheckDescriptor(new Elastic.Clients.Elasticsearch.Security.IndexPrivilegesCheck(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}