// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.IndexPrivilegeConverter))]
public readonly partial struct IndexPrivilege : Elastic.Clients.Elasticsearch.Serialization.IEnumStruct<Elastic.Clients.Elasticsearch.Security.IndexPrivilege>
{
	public IndexPrivilege(string value) => Value = value;
#if NET7_0_OR_GREATER
	static IndexPrivilege IEnumStruct<IndexPrivilege>.Create(string value) => value;
#else
	IndexPrivilege IEnumStruct<IndexPrivilege>.Create(string value) => value;
#endif
	public readonly string Value { get; }
	public static IndexPrivilege All { get; } = new IndexPrivilege("all");
	public static IndexPrivilege AutoConfigure { get; } = new IndexPrivilege("auto_configure");
	public static IndexPrivilege Create { get; } = new IndexPrivilege("create");
	public static IndexPrivilege CreateDoc { get; } = new IndexPrivilege("create_doc");
	public static IndexPrivilege CreateIndex { get; } = new IndexPrivilege("create_index");
	public static IndexPrivilege CrossClusterReplication { get; } = new IndexPrivilege("cross_cluster_replication");
	public static IndexPrivilege CrossClusterReplicationInternal { get; } = new IndexPrivilege("cross_cluster_replication_internal");
	public static IndexPrivilege Delete { get; } = new IndexPrivilege("delete");
	public static IndexPrivilege DeleteIndex { get; } = new IndexPrivilege("delete_index");
	public static IndexPrivilege Index { get; } = new IndexPrivilege("index");
	public static IndexPrivilege Maintenance { get; } = new IndexPrivilege("maintenance");
	public static IndexPrivilege Manage { get; } = new IndexPrivilege("manage");
	public static IndexPrivilege ManageDataStreamLifecycle { get; } = new IndexPrivilege("manage_data_stream_lifecycle");
	public static IndexPrivilege ManageFollowIndex { get; } = new IndexPrivilege("manage_follow_index");
	public static IndexPrivilege ManageIlm { get; } = new IndexPrivilege("manage_ilm");
	public static IndexPrivilege ManageLeaderIndex { get; } = new IndexPrivilege("manage_leader_index");
	public static IndexPrivilege Monitor { get; } = new IndexPrivilege("monitor");
	public static IndexPrivilege None { get; } = new IndexPrivilege("none");
	public static IndexPrivilege Read { get; } = new IndexPrivilege("read");
	public static IndexPrivilege ReadCrossCluster { get; } = new IndexPrivilege("read_cross_cluster");
	public static IndexPrivilege ViewIndexMetadata { get; } = new IndexPrivilege("view_index_metadata");
	public static IndexPrivilege Write { get; } = new IndexPrivilege("write");

	public override string ToString() => Value ?? string.Empty;

	public static implicit operator string(IndexPrivilege @enum) => @enum.Value;
	public static implicit operator IndexPrivilege(string value) => new(value);

	public override int GetHashCode() => Value.GetHashCode();
	public override bool Equals(object obj) => obj is IndexPrivilege other && this.Equals(other);
	public bool Equals(IndexPrivilege other) => Value == other.Value;

	public static bool operator ==(IndexPrivilege a, IndexPrivilege b) => a.Equals(b);
	public static bool operator !=(IndexPrivilege a, IndexPrivilege b) => !(a == b);
}