// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.HintConverter))]
public sealed partial class Hint
{
#if NET7_0_OR_GREATER
	public Hint()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public Hint()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Hint(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A single key-value pair to match against the labels section
	/// of a profile. A profile is considered matching if it matches
	/// at least one of the strings.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, System.Collections.Generic.ICollection<string>>? Labels { get; set; }

	/// <summary>
	/// <para>
	/// A list of profile UIDs to match against.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Uids { get; set; }
}

public readonly partial struct HintDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.Hint Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public HintDescriptor(Elastic.Clients.Elasticsearch.Security.Hint instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public HintDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.Hint(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.HintDescriptor(Elastic.Clients.Elasticsearch.Security.Hint instance) => new Elastic.Clients.Elasticsearch.Security.HintDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.Hint(Elastic.Clients.Elasticsearch.Security.HintDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A single key-value pair to match against the labels section
	/// of a profile. A profile is considered matching if it matches
	/// at least one of the strings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.HintDescriptor Labels(System.Collections.Generic.IDictionary<string, System.Collections.Generic.ICollection<string>>? value)
	{
		Instance.Labels = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A single key-value pair to match against the labels section
	/// of a profile. A profile is considered matching if it matches
	/// at least one of the strings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.HintDescriptor Labels()
	{
		Instance.Labels = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringCollectionOfString.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// A single key-value pair to match against the labels section
	/// of a profile. A profile is considered matching if it matches
	/// at least one of the strings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.HintDescriptor Labels(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringCollectionOfString>? action)
	{
		Instance.Labels = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringCollectionOfString.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.HintDescriptor AddLabel(string key, System.Collections.Generic.ICollection<string> value)
	{
		Instance.Labels ??= new System.Collections.Generic.Dictionary<string, System.Collections.Generic.ICollection<string>>();
		Instance.Labels.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.HintDescriptor AddLabel(string key, params string[] values)
	{
		Instance.Labels ??= new System.Collections.Generic.Dictionary<string, System.Collections.Generic.ICollection<string>>();
		Instance.Labels.Add(key, [.. values]);
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of profile UIDs to match against.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.HintDescriptor Uids(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Uids = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of profile UIDs to match against.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.HintDescriptor Uids(params string[] values)
	{
		Instance.Uids = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.Hint Build(System.Action<Elastic.Clients.Elasticsearch.Security.HintDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Security.Hint(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Security.HintDescriptor(new Elastic.Clients.Elasticsearch.Security.Hint(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}