// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.GrantApiKeyConverter))]
public sealed partial class GrantApiKey
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GrantApiKey(Elastic.Clients.Elasticsearch.Name name)
	{
		Name = name;
	}
#if NET7_0_OR_GREATER
	public GrantApiKey()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public GrantApiKey()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GrantApiKey(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Expiration time for the API key. By default, API keys never expire.
	/// </para>
	/// </summary>
	public string? Expiration { get; set; }

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key.
	/// It supports nested data structure.
	/// Within the <c>metadata</c> object, keys beginning with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Metadata { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Name Name { get; set; }

	/// <summary>
	/// <para>
	/// The role descriptors for this API key.
	/// When it is not specified or is an empty array, the API key has a point in time snapshot of permissions of the specified user or access token.
	/// If you supply role descriptors, the resultant permissions are an intersection of API keys permissions and the permissions of the user or access token.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>>? RoleDescriptors { get; set; }
}

public readonly partial struct GrantApiKeyDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Security.GrantApiKey Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GrantApiKeyDescriptor(Elastic.Clients.Elasticsearch.Security.GrantApiKey instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GrantApiKeyDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.GrantApiKey(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Security.GrantApiKey instance) => new Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.GrantApiKey(Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Expiration time for the API key. By default, API keys never expire.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor<TDocument> Expiration(string? value)
	{
		Instance.Expiration = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key.
	/// It supports nested data structure.
	/// Within the <c>metadata</c> object, keys beginning with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor<TDocument> Metadata(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Metadata = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key.
	/// It supports nested data structure.
	/// Within the <c>metadata</c> object, keys beginning with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor<TDocument> Metadata()
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key.
	/// It supports nested data structure.
	/// Within the <c>metadata</c> object, keys beginning with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor<TDocument> Metadata(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor<TDocument> AddMetadatum(string key, object value)
	{
		Instance.Metadata ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Metadata.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor<TDocument> Name(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The role descriptors for this API key.
	/// When it is not specified or is an empty array, the API key has a point in time snapshot of permissions of the specified user or access token.
	/// If you supply role descriptors, the resultant permissions are an intersection of API keys permissions and the permissions of the user or access token.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor<TDocument> RoleDescriptors(System.Collections.Generic.ICollection<System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>>? value)
	{
		Instance.RoleDescriptors = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The role descriptors for this API key.
	/// When it is not specified or is an empty array, the API key has a point in time snapshot of permissions of the specified user or access token.
	/// If you supply role descriptors, the resultant permissions are an intersection of API keys permissions and the permissions of the user or access token.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor<TDocument> RoleDescriptors(params System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>[] values)
	{
		Instance.RoleDescriptors = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The role descriptors for this API key.
	/// When it is not specified or is an empty array, the API key has a point in time snapshot of permissions of the specified user or access token.
	/// If you supply role descriptors, the resultant permissions are an intersection of API keys permissions and the permissions of the user or access token.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor<TDocument> RoleDescriptors(params System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor<TDocument>>?[] actions)
	{
		var items = new System.Collections.Generic.List<System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor<TDocument>.Build(action));
		}

		Instance.RoleDescriptors = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.GrantApiKey Build(System.Action<Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Security.GrantApiKey(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct GrantApiKeyDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.GrantApiKey Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GrantApiKeyDescriptor(Elastic.Clients.Elasticsearch.Security.GrantApiKey instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GrantApiKeyDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.GrantApiKey(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor(Elastic.Clients.Elasticsearch.Security.GrantApiKey instance) => new Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.GrantApiKey(Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Expiration time for the API key. By default, API keys never expire.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor Expiration(string? value)
	{
		Instance.Expiration = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key.
	/// It supports nested data structure.
	/// Within the <c>metadata</c> object, keys beginning with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor Metadata(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Metadata = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key.
	/// It supports nested data structure.
	/// Within the <c>metadata</c> object, keys beginning with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor Metadata()
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key.
	/// It supports nested data structure.
	/// Within the <c>metadata</c> object, keys beginning with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor Metadata(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor AddMetadatum(string key, object value)
	{
		Instance.Metadata ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Metadata.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor Name(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The role descriptors for this API key.
	/// When it is not specified or is an empty array, the API key has a point in time snapshot of permissions of the specified user or access token.
	/// If you supply role descriptors, the resultant permissions are an intersection of API keys permissions and the permissions of the user or access token.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor RoleDescriptors(System.Collections.Generic.ICollection<System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>>? value)
	{
		Instance.RoleDescriptors = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The role descriptors for this API key.
	/// When it is not specified or is an empty array, the API key has a point in time snapshot of permissions of the specified user or access token.
	/// If you supply role descriptors, the resultant permissions are an intersection of API keys permissions and the permissions of the user or access token.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor RoleDescriptors(params System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>[] values)
	{
		Instance.RoleDescriptors = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The role descriptors for this API key.
	/// When it is not specified or is an empty array, the API key has a point in time snapshot of permissions of the specified user or access token.
	/// If you supply role descriptors, the resultant permissions are an intersection of API keys permissions and the permissions of the user or access token.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor RoleDescriptors(params System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor>?[] actions)
	{
		var items = new System.Collections.Generic.List<System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor.Build(action));
		}

		Instance.RoleDescriptors = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The role descriptors for this API key.
	/// When it is not specified or is an empty array, the API key has a point in time snapshot of permissions of the specified user or access token.
	/// If you supply role descriptors, the resultant permissions are an intersection of API keys permissions and the permissions of the user or access token.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor RoleDescriptors<T>(params System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor<T>>?[] actions)
	{
		var items = new System.Collections.Generic.List<System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor<T>.Build(action));
		}

		Instance.RoleDescriptors = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.GrantApiKey Build(System.Action<Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor(new Elastic.Clients.Elasticsearch.Security.GrantApiKey(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}