// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.ClusterPrivilegeConverter))]
public readonly partial struct ClusterPrivilege : Elastic.Clients.Elasticsearch.Serialization.IEnumStruct<Elastic.Clients.Elasticsearch.Security.ClusterPrivilege>
{
	public ClusterPrivilege(string value) => Value = value;
#if NET7_0_OR_GREATER
	static ClusterPrivilege IEnumStruct<ClusterPrivilege>.Create(string value) => value;
#else
	ClusterPrivilege IEnumStruct<ClusterPrivilege>.Create(string value) => value;
#endif
	public readonly string Value { get; }
	public static ClusterPrivilege All { get; } = new ClusterPrivilege("all");
	public static ClusterPrivilege CancelTask { get; } = new ClusterPrivilege("cancel_task");
	public static ClusterPrivilege CreateSnapshot { get; } = new ClusterPrivilege("create_snapshot");
	public static ClusterPrivilege CrossClusterReplication { get; } = new ClusterPrivilege("cross_cluster_replication");
	public static ClusterPrivilege CrossClusterSearch { get; } = new ClusterPrivilege("cross_cluster_search");
	public static ClusterPrivilege DelegatePki { get; } = new ClusterPrivilege("delegate_pki");
	public static ClusterPrivilege GrantApiKey { get; } = new ClusterPrivilege("grant_api_key");
	public static ClusterPrivilege Manage { get; } = new ClusterPrivilege("manage");
	public static ClusterPrivilege ManageApiKey { get; } = new ClusterPrivilege("manage_api_key");
	public static ClusterPrivilege ManageAutoscaling { get; } = new ClusterPrivilege("manage_autoscaling");
	public static ClusterPrivilege ManageBehavioralAnalytics { get; } = new ClusterPrivilege("manage_behavioral_analytics");
	public static ClusterPrivilege ManageCcr { get; } = new ClusterPrivilege("manage_ccr");
	public static ClusterPrivilege ManageDataFrameTransforms { get; } = new ClusterPrivilege("manage_data_frame_transforms");
	public static ClusterPrivilege ManageDataStreamGlobalRetention { get; } = new ClusterPrivilege("manage_data_stream_global_retention");
	public static ClusterPrivilege ManageEnrich { get; } = new ClusterPrivilege("manage_enrich");
	public static ClusterPrivilege ManageEsql { get; } = new ClusterPrivilege("manage_esql");
	public static ClusterPrivilege ManageIlm { get; } = new ClusterPrivilege("manage_ilm");
	public static ClusterPrivilege ManageIndexTemplates { get; } = new ClusterPrivilege("manage_index_templates");
	public static ClusterPrivilege ManageInference { get; } = new ClusterPrivilege("manage_inference");
	public static ClusterPrivilege ManageIngestPipelines { get; } = new ClusterPrivilege("manage_ingest_pipelines");
	public static ClusterPrivilege ManageLogstashPipelines { get; } = new ClusterPrivilege("manage_logstash_pipelines");
	public static ClusterPrivilege ManageMl { get; } = new ClusterPrivilege("manage_ml");
	public static ClusterPrivilege ManageOidc { get; } = new ClusterPrivilege("manage_oidc");
	public static ClusterPrivilege ManageOwnApiKey { get; } = new ClusterPrivilege("manage_own_api_key");
	public static ClusterPrivilege ManagePipeline { get; } = new ClusterPrivilege("manage_pipeline");
	public static ClusterPrivilege ManageRollup { get; } = new ClusterPrivilege("manage_rollup");
	public static ClusterPrivilege ManageSaml { get; } = new ClusterPrivilege("manage_saml");
	public static ClusterPrivilege ManageSearchApplication { get; } = new ClusterPrivilege("manage_search_application");
	public static ClusterPrivilege ManageSearchQueryRules { get; } = new ClusterPrivilege("manage_search_query_rules");
	public static ClusterPrivilege ManageSearchSynonyms { get; } = new ClusterPrivilege("manage_search_synonyms");
	public static ClusterPrivilege ManageSecurity { get; } = new ClusterPrivilege("manage_security");
	public static ClusterPrivilege ManageServiceAccount { get; } = new ClusterPrivilege("manage_service_account");
	public static ClusterPrivilege ManageSlm { get; } = new ClusterPrivilege("manage_slm");
	public static ClusterPrivilege ManageToken { get; } = new ClusterPrivilege("manage_token");
	public static ClusterPrivilege ManageTransform { get; } = new ClusterPrivilege("manage_transform");
	public static ClusterPrivilege ManageUserProfile { get; } = new ClusterPrivilege("manage_user_profile");
	public static ClusterPrivilege ManageWatcher { get; } = new ClusterPrivilege("manage_watcher");
	public static ClusterPrivilege Monitor { get; } = new ClusterPrivilege("monitor");
	public static ClusterPrivilege MonitorDataFrameTransforms { get; } = new ClusterPrivilege("monitor_data_frame_transforms");
	public static ClusterPrivilege MonitorDataStreamGlobalRetention { get; } = new ClusterPrivilege("monitor_data_stream_global_retention");
	public static ClusterPrivilege MonitorEnrich { get; } = new ClusterPrivilege("monitor_enrich");
	public static ClusterPrivilege MonitorEsql { get; } = new ClusterPrivilege("monitor_esql");
	public static ClusterPrivilege MonitorInference { get; } = new ClusterPrivilege("monitor_inference");
	public static ClusterPrivilege MonitorMl { get; } = new ClusterPrivilege("monitor_ml");
	public static ClusterPrivilege MonitorRollup { get; } = new ClusterPrivilege("monitor_rollup");
	public static ClusterPrivilege MonitorSnapshot { get; } = new ClusterPrivilege("monitor_snapshot");
	public static ClusterPrivilege MonitorStats { get; } = new ClusterPrivilege("monitor_stats");
	public static ClusterPrivilege MonitorTextStructure { get; } = new ClusterPrivilege("monitor_text_structure");
	public static ClusterPrivilege MonitorTransform { get; } = new ClusterPrivilege("monitor_transform");
	public static ClusterPrivilege MonitorWatcher { get; } = new ClusterPrivilege("monitor_watcher");
	public static ClusterPrivilege None { get; } = new ClusterPrivilege("none");
	public static ClusterPrivilege PostBehavioralAnalyticsEvent { get; } = new ClusterPrivilege("post_behavioral_analytics_event");
	public static ClusterPrivilege ReadCcr { get; } = new ClusterPrivilege("read_ccr");
	public static ClusterPrivilege ReadFleetSecrets { get; } = new ClusterPrivilege("read_fleet_secrets");
	public static ClusterPrivilege ReadIlm { get; } = new ClusterPrivilege("read_ilm");
	public static ClusterPrivilege ReadPipeline { get; } = new ClusterPrivilege("read_pipeline");
	public static ClusterPrivilege ReadSecurity { get; } = new ClusterPrivilege("read_security");
	public static ClusterPrivilege ReadSlm { get; } = new ClusterPrivilege("read_slm");
	public static ClusterPrivilege TransportClient { get; } = new ClusterPrivilege("transport_client");
	public static ClusterPrivilege WriteConnectorSecrets { get; } = new ClusterPrivilege("write_connector_secrets");
	public static ClusterPrivilege WriteFleetSecrets { get; } = new ClusterPrivilege("write_fleet_secrets");

	public override string ToString() => Value ?? string.Empty;

	public static implicit operator string(ClusterPrivilege @enum) => @enum.Value;
	public static implicit operator ClusterPrivilege(string value) => new(value);

	public override int GetHashCode() => Value.GetHashCode();
	public override bool Equals(object obj) => obj is ClusterPrivilege other && this.Equals(other);
	public bool Equals(ClusterPrivilege other) => Value == other.Value;

	public static bool operator ==(ClusterPrivilege a, ClusterPrivilege b) => a.Equals(b);
	public static bool operator !=(ClusterPrivilege a, ClusterPrivilege b) => !(a == b);
}