// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.ApplicationPrivilegesCheckConverter))]
public sealed partial class ApplicationPrivilegesCheck
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ApplicationPrivilegesCheck(string application, System.Collections.Generic.ICollection<string> privileges, System.Collections.Generic.ICollection<string> resources)
	{
		Application = application;
		Privileges = privileges;
		Resources = resources;
	}
#if NET7_0_OR_GREATER
	public ApplicationPrivilegesCheck()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ApplicationPrivilegesCheck()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ApplicationPrivilegesCheck(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The name of the application.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Application { get; set; }

	/// <summary>
	/// <para>
	/// A list of the privileges that you want to check for the specified resources.
	/// It may be either application privilege names or the names of actions that are granted by those privileges
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<string> Privileges { get; set; }

	/// <summary>
	/// <para>
	/// A list of resource names against which the privileges should be checked.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<string> Resources { get; set; }
}

public readonly partial struct ApplicationPrivilegesCheckDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesCheck Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ApplicationPrivilegesCheckDescriptor(Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesCheck instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ApplicationPrivilegesCheckDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesCheck(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesCheckDescriptor(Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesCheck instance) => new Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesCheckDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesCheck(Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesCheckDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The name of the application.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesCheckDescriptor Application(string value)
	{
		Instance.Application = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of the privileges that you want to check for the specified resources.
	/// It may be either application privilege names or the names of actions that are granted by those privileges
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesCheckDescriptor Privileges(System.Collections.Generic.ICollection<string> value)
	{
		Instance.Privileges = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of the privileges that you want to check for the specified resources.
	/// It may be either application privilege names or the names of actions that are granted by those privileges
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesCheckDescriptor Privileges(params string[] values)
	{
		Instance.Privileges = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of resource names against which the privileges should be checked.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesCheckDescriptor Resources(System.Collections.Generic.ICollection<string> value)
	{
		Instance.Resources = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of resource names against which the privileges should be checked.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesCheckDescriptor Resources(params string[] values)
	{
		Instance.Resources = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesCheck Build(System.Action<Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesCheckDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesCheckDescriptor(new Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesCheck(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}