// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.ApplicationPrivilegesConverter))]
public sealed partial class ApplicationPrivileges
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ApplicationPrivileges(string application, System.Collections.Generic.ICollection<string> privileges, System.Collections.Generic.ICollection<string> resources)
	{
		Application = application;
		Privileges = privileges;
		Resources = resources;
	}
#if NET7_0_OR_GREATER
	public ApplicationPrivileges()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ApplicationPrivileges()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ApplicationPrivileges(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The name of the application to which this entry applies.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Application { get; set; }

	/// <summary>
	/// <para>
	/// A list of strings, where each element is the name of an application privilege or action.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<string> Privileges { get; set; }

	/// <summary>
	/// <para>
	/// A list resources to which the privileges are applied.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<string> Resources { get; set; }
}

public readonly partial struct ApplicationPrivilegesDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.ApplicationPrivileges Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ApplicationPrivilegesDescriptor(Elastic.Clients.Elasticsearch.Security.ApplicationPrivileges instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ApplicationPrivilegesDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.ApplicationPrivileges(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesDescriptor(Elastic.Clients.Elasticsearch.Security.ApplicationPrivileges instance) => new Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.ApplicationPrivileges(Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The name of the application to which this entry applies.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesDescriptor Application(string value)
	{
		Instance.Application = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of strings, where each element is the name of an application privilege or action.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesDescriptor Privileges(System.Collections.Generic.ICollection<string> value)
	{
		Instance.Privileges = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of strings, where each element is the name of an application privilege or action.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesDescriptor Privileges(params string[] values)
	{
		Instance.Privileges = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list resources to which the privileges are applied.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesDescriptor Resources(System.Collections.Generic.ICollection<string> value)
	{
		Instance.Resources = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list resources to which the privileges are applied.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesDescriptor Resources(params string[] values)
	{
		Instance.Resources = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.ApplicationPrivileges Build(System.Action<Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesDescriptor(new Elastic.Clients.Elasticsearch.Security.ApplicationPrivileges(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}