// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security.Json;

public sealed partial class ApiKeyTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Security.ApiKeyType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberCrossCluster = System.Text.Json.JsonEncodedText.Encode("cross_cluster");
	private static readonly System.Text.Json.JsonEncodedText MemberRest = System.Text.Json.JsonEncodedText.Encode("rest");

	public override Elastic.Clients.Elasticsearch.Security.ApiKeyType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberCrossCluster))
		{
			return Elastic.Clients.Elasticsearch.Security.ApiKeyType.CrossCluster;
		}

		if (reader.ValueTextEquals(MemberRest))
		{
			return Elastic.Clients.Elasticsearch.Security.ApiKeyType.Rest;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberCrossCluster.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Security.ApiKeyType.CrossCluster;
		}

		if (string.Equals(value, MemberRest.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Security.ApiKeyType.Rest;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Security.ApiKeyType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Security.ApiKeyType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Security.ApiKeyType.CrossCluster:
				writer.WriteStringValue(MemberCrossCluster);
				break;
			case Elastic.Clients.Elasticsearch.Security.ApiKeyType.Rest:
				writer.WriteStringValue(MemberRest);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Security.ApiKeyType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Security.ApiKeyType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Security.ApiKeyType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}