// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.ApiKeyFiltersAggregationConverter))]
public sealed partial class ApiKeyFiltersAggregation
{
#if NET7_0_OR_GREATER
	public ApiKeyFiltersAggregation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public ApiKeyFiltersAggregation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ApiKeyFiltersAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Collection of queries from which to build buckets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.Buckets<Elastic.Clients.Elasticsearch.Security.ApiKeyQuery>? Filters { get; set; }

	/// <summary>
	/// <para>
	/// By default, the named filters aggregation returns the buckets as an object.
	/// Set to <c>false</c> to return the buckets as an array of objects.
	/// </para>
	/// </summary>
	public bool? Keyed => false;

	/// <summary>
	/// <para>
	/// Set to <c>true</c> to add a bucket to the response which will contain all documents that do not match any of the given filters.
	/// </para>
	/// </summary>
	public bool? OtherBucket { get; set; }

	/// <summary>
	/// <para>
	/// The key with which the other bucket is returned.
	/// </para>
	/// </summary>
	public string? OtherBucketKey { get; set; }
}

public readonly partial struct ApiKeyFiltersAggregationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ApiKeyFiltersAggregationDescriptor(Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ApiKeyFiltersAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregation instance) => new Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregation(Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Collection of queries from which to build buckets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregationDescriptor<TDocument> Filters(Elastic.Clients.Elasticsearch.Aggregations.Buckets<Elastic.Clients.Elasticsearch.Security.ApiKeyQuery>? value)
	{
		Instance.Filters = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Collection of queries from which to build buckets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregationDescriptor<TDocument> Filters(System.Func<Elastic.Clients.Elasticsearch.Aggregations.BucketsOfApiKeyQueryFactory<TDocument>, Elastic.Clients.Elasticsearch.Aggregations.Buckets<Elastic.Clients.Elasticsearch.Security.ApiKeyQuery>> action)
	{
		Instance.Filters = Elastic.Clients.Elasticsearch.Aggregations.BucketsOfApiKeyQueryFactory<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Set to <c>true</c> to add a bucket to the response which will contain all documents that do not match any of the given filters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregationDescriptor<TDocument> OtherBucket(bool? value = true)
	{
		Instance.OtherBucket = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The key with which the other bucket is returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregationDescriptor<TDocument> OtherBucketKey(string? value)
	{
		Instance.OtherBucketKey = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregationDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct ApiKeyFiltersAggregationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ApiKeyFiltersAggregationDescriptor(Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ApiKeyFiltersAggregationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregationDescriptor(Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregation instance) => new Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregation(Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Collection of queries from which to build buckets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregationDescriptor Filters(Elastic.Clients.Elasticsearch.Aggregations.Buckets<Elastic.Clients.Elasticsearch.Security.ApiKeyQuery>? value)
	{
		Instance.Filters = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Collection of queries from which to build buckets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregationDescriptor Filters(System.Func<Elastic.Clients.Elasticsearch.Aggregations.BucketsOfApiKeyQueryFactory, Elastic.Clients.Elasticsearch.Aggregations.Buckets<Elastic.Clients.Elasticsearch.Security.ApiKeyQuery>> action)
	{
		Instance.Filters = Elastic.Clients.Elasticsearch.Aggregations.BucketsOfApiKeyQueryFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Collection of queries from which to build buckets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregationDescriptor Filters<T>(System.Func<Elastic.Clients.Elasticsearch.Aggregations.BucketsOfApiKeyQueryFactory<T>, Elastic.Clients.Elasticsearch.Aggregations.Buckets<Elastic.Clients.Elasticsearch.Security.ApiKeyQuery>> action)
	{
		Instance.Filters = Elastic.Clients.Elasticsearch.Aggregations.BucketsOfApiKeyQueryFactory<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Set to <c>true</c> to add a bucket to the response which will contain all documents that do not match any of the given filters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregationDescriptor OtherBucket(bool? value = true)
	{
		Instance.OtherBucket = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The key with which the other bucket is returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregationDescriptor OtherBucketKey(string? value)
	{
		Instance.OtherBucketKey = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregation Build(System.Action<Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregationDescriptor(new Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}