// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security.Json;

public sealed partial class ApiKeyAggregationConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Security.ApiKeyAggregation>
{
	private static readonly System.Text.Json.JsonEncodedText PropAggregations = System.Text.Json.JsonEncodedText.Encode("aggregations");
	private static readonly System.Text.Json.JsonEncodedText PropAggregations1 = System.Text.Json.JsonEncodedText.Encode("aggs");
	private static readonly System.Text.Json.JsonEncodedText PropMeta = System.Text.Json.JsonEncodedText.Encode("meta");
	private static readonly System.Text.Json.JsonEncodedText VariantCardinality = System.Text.Json.JsonEncodedText.Encode("cardinality");
	private static readonly System.Text.Json.JsonEncodedText VariantComposite = System.Text.Json.JsonEncodedText.Encode("composite");
	private static readonly System.Text.Json.JsonEncodedText VariantDateRange = System.Text.Json.JsonEncodedText.Encode("date_range");
	private static readonly System.Text.Json.JsonEncodedText VariantFilter = System.Text.Json.JsonEncodedText.Encode("filter");
	private static readonly System.Text.Json.JsonEncodedText VariantFilters = System.Text.Json.JsonEncodedText.Encode("filters");
	private static readonly System.Text.Json.JsonEncodedText VariantMissing = System.Text.Json.JsonEncodedText.Encode("missing");
	private static readonly System.Text.Json.JsonEncodedText VariantRange = System.Text.Json.JsonEncodedText.Encode("range");
	private static readonly System.Text.Json.JsonEncodedText VariantTerms = System.Text.Json.JsonEncodedText.Encode("terms");
	private static readonly System.Text.Json.JsonEncodedText VariantValueCount = System.Text.Json.JsonEncodedText.Encode("value_count");

	public override Elastic.Clients.Elasticsearch.Security.ApiKeyAggregation Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Security.ApiKeyAggregation>?> propAggregations = default;
		LocalJsonValue<System.Collections.Generic.IDictionary<string, object>?> propMeta = default;
		string? variantType = null;
		object? variant = null;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAggregations.TryReadProperty(ref reader, options, PropAggregations, static System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Security.ApiKeyAggregation>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, Elastic.Clients.Elasticsearch.Security.ApiKeyAggregation>(o, null, null)) || propAggregations.TryReadProperty(ref reader, options, PropAggregations1, static System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Security.ApiKeyAggregation>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, Elastic.Clients.Elasticsearch.Security.ApiKeyAggregation>(o, null, null)))
			{
				continue;
			}

			if (propMeta.TryReadProperty(ref reader, options, PropMeta, static System.Collections.Generic.IDictionary<string, object>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, object>(o, null, static object (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<object>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.SourceMarker<object>))!)))
			{
				continue;
			}

			if (reader.ValueTextEquals(VariantCardinality))
			{
				variantType = VariantCardinality.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantComposite))
			{
				variantType = VariantComposite.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantDateRange))
			{
				variantType = VariantDateRange.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantFilter))
			{
				variantType = VariantFilter.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Security.ApiKeyQuery>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantFilters))
			{
				variantType = VariantFilters.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantMissing))
			{
				variantType = VariantMissing.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.MissingAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantRange))
			{
				variantType = VariantRange.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.RangeAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantTerms))
			{
				variantType = VariantTerms.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantValueCount))
			{
				variantType = VariantValueCount.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Aggregations.ValueCountAggregation>(options, null);
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Security.ApiKeyAggregation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			VariantType = variantType,
			Variant = variant,
			Aggregations = propAggregations.Value,
			Meta = propMeta.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Security.ApiKeyAggregation value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		switch (value.VariantType)
		{
			case null:
				break;
			case "cardinality":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.CardinalityAggregation)value.Variant, null, null);
				break;
			case "composite":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.CompositeAggregation)value.Variant, null, null);
				break;
			case "date_range":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.DateRangeAggregation)value.Variant, null, null);
				break;
			case "filter":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Security.ApiKeyQuery)value.Variant, null, null);
				break;
			case "filters":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Security.ApiKeyFiltersAggregation)value.Variant, null, null);
				break;
			case "missing":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.MissingAggregation)value.Variant, null, null);
				break;
			case "range":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.RangeAggregation)value.Variant, null, null);
				break;
			case "terms":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.TermsAggregation)value.Variant, null, null);
				break;
			case "value_count":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Aggregations.ValueCountAggregation)value.Variant, null, null);
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.VariantType}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.Security.ApiKeyAggregation)}'.");
		}

		writer.WriteProperty(options, PropAggregations, value.Aggregations, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Security.ApiKeyAggregation>? v) => w.WriteDictionaryValue<string, Elastic.Clients.Elasticsearch.Security.ApiKeyAggregation>(o, v, null, null));
		writer.WriteProperty(options, PropMeta, value.Meta, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IDictionary<string, object>? v) => w.WriteDictionaryValue<string, object>(o, v, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, object v) => w.WriteValueEx<object>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.SourceMarker<object>))));
		writer.WriteEndObject();
	}
}