// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.ApiKeyConverter))]
public sealed partial class ApiKey
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ApiKey(System.DateTimeOffset creation, string id, bool invalidated, System.Collections.Generic.IReadOnlyDictionary<string, object> metadata, string name, string realm, Elastic.Clients.Elasticsearch.Security.ApiKeyType type, string username)
	{
		Creation = creation;
		Id = id;
		Invalidated = invalidated;
		Metadata = metadata;
		Name = name;
		Realm = realm;
		Type = type;
		Username = username;
	}
#if NET7_0_OR_GREATER
	public ApiKey()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ApiKey()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ApiKey(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The access granted to cross-cluster API keys.
	/// The access is composed of permissions for cross cluster search and cross cluster replication.
	/// At least one of them must be specified.
	/// When specified, the new access assignment fully replaces the previously assigned access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.Access? Access { get; set; }

	/// <summary>
	/// <para>
	/// Creation time for the API key in milliseconds.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.DateTimeOffset Creation { get; set; }

	/// <summary>
	/// <para>
	/// Expiration time for the API key in milliseconds.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? Expiration { get; set; }

	/// <summary>
	/// <para>
	/// Id for the API key
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Id { get; set; }

	/// <summary>
	/// <para>
	/// Invalidation status for the API key.
	/// If the key has been invalidated, it has a value of <c>true</c>. Otherwise, it is <c>false</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool Invalidated { get; set; }

	/// <summary>
	/// <para>
	/// If the key has been invalidated, invalidation time in milliseconds.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? Invalidation { get; set; }

	/// <summary>
	/// <para>
	/// The owner user’s permissions associated with the API key.
	/// It is a point-in-time snapshot captured at creation and subsequent updates.
	/// An API key’s effective permissions are an intersection of its assigned privileges and the owner user’s permissions.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyCollection<System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>>? LimitedBy { get; set; }

	/// <summary>
	/// <para>
	/// Metadata of the API key
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyDictionary<string, object> Metadata { get; set; }

	/// <summary>
	/// <para>
	/// Name of the API key.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Name { get; set; }

	/// <summary>
	/// <para>
	/// The profile uid for the API key owner principal, if requested and if it exists
	/// </para>
	/// </summary>
	public string? ProfileUid { get; set; }

	/// <summary>
	/// <para>
	/// Realm name of the principal for which this API key was created.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Realm { get; set; }

	/// <summary>
	/// <para>
	/// Realm type of the principal for which this API key was created
	/// </para>
	/// </summary>
	public string? RealmType { get; set; }

	/// <summary>
	/// <para>
	/// The role descriptors assigned to this API key when it was created or last updated.
	/// An empty role descriptor means the API key inherits the owner user’s permissions.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>? RoleDescriptors { get; set; }

	/// <summary>
	/// <para>
	/// Sorting values when using the <c>sort</c> parameter with the <c>security.query_api_keys</c> API.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.FieldValue>? Sort { get; set; }

	/// <summary>
	/// <para>
	/// The type of the API key (e.g. <c>rest</c> or <c>cross_cluster</c>).
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Security.ApiKeyType Type { get; set; }

	/// <summary>
	/// <para>
	/// Principal for which this API key was created
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Username { get; set; }
}