// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security.Json;

public sealed partial class AccessTokenGrantTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Security.AccessTokenGrantType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberKerberos = System.Text.Json.JsonEncodedText.Encode("_kerberos");
	private static readonly System.Text.Json.JsonEncodedText MemberClientCredentials = System.Text.Json.JsonEncodedText.Encode("client_credentials");
	private static readonly System.Text.Json.JsonEncodedText MemberPassword = System.Text.Json.JsonEncodedText.Encode("password");
	private static readonly System.Text.Json.JsonEncodedText MemberRefreshToken = System.Text.Json.JsonEncodedText.Encode("refresh_token");

	public override Elastic.Clients.Elasticsearch.Security.AccessTokenGrantType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberKerberos))
		{
			return Elastic.Clients.Elasticsearch.Security.AccessTokenGrantType.Kerberos;
		}

		if (reader.ValueTextEquals(MemberClientCredentials))
		{
			return Elastic.Clients.Elasticsearch.Security.AccessTokenGrantType.ClientCredentials;
		}

		if (reader.ValueTextEquals(MemberPassword))
		{
			return Elastic.Clients.Elasticsearch.Security.AccessTokenGrantType.Password;
		}

		if (reader.ValueTextEquals(MemberRefreshToken))
		{
			return Elastic.Clients.Elasticsearch.Security.AccessTokenGrantType.RefreshToken;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberKerberos.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Security.AccessTokenGrantType.Kerberos;
		}

		if (string.Equals(value, MemberClientCredentials.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Security.AccessTokenGrantType.ClientCredentials;
		}

		if (string.Equals(value, MemberPassword.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Security.AccessTokenGrantType.Password;
		}

		if (string.Equals(value, MemberRefreshToken.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Security.AccessTokenGrantType.RefreshToken;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Security.AccessTokenGrantType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Security.AccessTokenGrantType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Security.AccessTokenGrantType.Kerberos:
				writer.WriteStringValue(MemberKerberos);
				break;
			case Elastic.Clients.Elasticsearch.Security.AccessTokenGrantType.ClientCredentials:
				writer.WriteStringValue(MemberClientCredentials);
				break;
			case Elastic.Clients.Elasticsearch.Security.AccessTokenGrantType.Password:
				writer.WriteStringValue(MemberPassword);
				break;
			case Elastic.Clients.Elasticsearch.Security.AccessTokenGrantType.RefreshToken:
				writer.WriteStringValue(MemberRefreshToken);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Security.AccessTokenGrantType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Security.AccessTokenGrantType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Security.AccessTokenGrantType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}