// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.SearchableSnapshots.Json;

public sealed partial class SharedConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.SearchableSnapshots.Shared>
{
	private static readonly System.Text.Json.JsonEncodedText PropBytesReadInBytes = System.Text.Json.JsonEncodedText.Encode("bytes_read_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropBytesWrittenInBytes = System.Text.Json.JsonEncodedText.Encode("bytes_written_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropEvictions = System.Text.Json.JsonEncodedText.Encode("evictions");
	private static readonly System.Text.Json.JsonEncodedText PropNumRegions = System.Text.Json.JsonEncodedText.Encode("num_regions");
	private static readonly System.Text.Json.JsonEncodedText PropReads = System.Text.Json.JsonEncodedText.Encode("reads");
	private static readonly System.Text.Json.JsonEncodedText PropRegionSizeInBytes = System.Text.Json.JsonEncodedText.Encode("region_size_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropSizeInBytes = System.Text.Json.JsonEncodedText.Encode("size_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropWrites = System.Text.Json.JsonEncodedText.Encode("writes");

	public override Elastic.Clients.Elasticsearch.SearchableSnapshots.Shared Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize> propBytesReadInBytes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize> propBytesWrittenInBytes = default;
		LocalJsonValue<long> propEvictions = default;
		LocalJsonValue<int> propNumRegions = default;
		LocalJsonValue<long> propReads = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize> propRegionSizeInBytes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize> propSizeInBytes = default;
		LocalJsonValue<long> propWrites = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propBytesReadInBytes.TryReadProperty(ref reader, options, PropBytesReadInBytes, null))
			{
				continue;
			}

			if (propBytesWrittenInBytes.TryReadProperty(ref reader, options, PropBytesWrittenInBytes, null))
			{
				continue;
			}

			if (propEvictions.TryReadProperty(ref reader, options, PropEvictions, null))
			{
				continue;
			}

			if (propNumRegions.TryReadProperty(ref reader, options, PropNumRegions, null))
			{
				continue;
			}

			if (propReads.TryReadProperty(ref reader, options, PropReads, null))
			{
				continue;
			}

			if (propRegionSizeInBytes.TryReadProperty(ref reader, options, PropRegionSizeInBytes, null))
			{
				continue;
			}

			if (propSizeInBytes.TryReadProperty(ref reader, options, PropSizeInBytes, null))
			{
				continue;
			}

			if (propWrites.TryReadProperty(ref reader, options, PropWrites, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.SearchableSnapshots.Shared(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			BytesReadInBytes = propBytesReadInBytes.Value,
			BytesWrittenInBytes = propBytesWrittenInBytes.Value,
			Evictions = propEvictions.Value,
			NumRegions = propNumRegions.Value,
			Reads = propReads.Value,
			RegionSizeInBytes = propRegionSizeInBytes.Value,
			SizeInBytes = propSizeInBytes.Value,
			Writes = propWrites.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.SearchableSnapshots.Shared value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropBytesReadInBytes, value.BytesReadInBytes, null, null);
		writer.WriteProperty(options, PropBytesWrittenInBytes, value.BytesWrittenInBytes, null, null);
		writer.WriteProperty(options, PropEvictions, value.Evictions, null, null);
		writer.WriteProperty(options, PropNumRegions, value.NumRegions, null, null);
		writer.WriteProperty(options, PropReads, value.Reads, null, null);
		writer.WriteProperty(options, PropRegionSizeInBytes, value.RegionSizeInBytes, null, null);
		writer.WriteProperty(options, PropSizeInBytes, value.SizeInBytes, null, null);
		writer.WriteProperty(options, PropWrites, value.Writes, null, null);
		writer.WriteEndObject();
	}
}