// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class SearchTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.SearchType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberDfsQueryThenFetch = System.Text.Json.JsonEncodedText.Encode("dfs_query_then_fetch");
	private static readonly System.Text.Json.JsonEncodedText MemberQueryThenFetch = System.Text.Json.JsonEncodedText.Encode("query_then_fetch");

	public override Elastic.Clients.Elasticsearch.SearchType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberDfsQueryThenFetch))
		{
			return Elastic.Clients.Elasticsearch.SearchType.DfsQueryThenFetch;
		}

		if (reader.ValueTextEquals(MemberQueryThenFetch))
		{
			return Elastic.Clients.Elasticsearch.SearchType.QueryThenFetch;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberDfsQueryThenFetch.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.SearchType.DfsQueryThenFetch;
		}

		if (string.Equals(value, MemberQueryThenFetch.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.SearchType.QueryThenFetch;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.SearchType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.SearchType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.SearchType.DfsQueryThenFetch:
				writer.WriteStringValue(MemberDfsQueryThenFetch);
				break;
			case Elastic.Clients.Elasticsearch.SearchType.QueryThenFetch:
				writer.WriteStringValue(MemberQueryThenFetch);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.SearchType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.SearchType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.SearchType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}