// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.SearchStatsConverter))]
public sealed partial class SearchStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SearchStats(long fetchCurrent, System.TimeSpan fetchTimeInMillis, long fetchTotal, long queryCurrent, System.TimeSpan queryTimeInMillis, long queryTotal, long scrollCurrent, System.TimeSpan scrollTimeInMillis, long scrollTotal, long suggestCurrent, System.TimeSpan suggestTimeInMillis, long suggestTotal)
	{
		FetchCurrent = fetchCurrent;
		FetchTimeInMillis = fetchTimeInMillis;
		FetchTotal = fetchTotal;
		QueryCurrent = queryCurrent;
		QueryTimeInMillis = queryTimeInMillis;
		QueryTotal = queryTotal;
		ScrollCurrent = scrollCurrent;
		ScrollTimeInMillis = scrollTimeInMillis;
		ScrollTotal = scrollTotal;
		SuggestCurrent = suggestCurrent;
		SuggestTimeInMillis = suggestTimeInMillis;
		SuggestTotal = suggestTotal;
	}
#if NET7_0_OR_GREATER
	public SearchStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public SearchStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SearchStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public
#if NET7_0_OR_GREATER
	required
#endif
	long FetchCurrent { get; set; }
	public Elastic.Clients.Elasticsearch.Duration? FetchTime { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan FetchTimeInMillis { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long FetchTotal { get; set; }
	public System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.SearchStats>? Groups { get; set; }
	public long? OpenContexts { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long QueryCurrent { get; set; }
	public Elastic.Clients.Elasticsearch.Duration? QueryTime { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan QueryTimeInMillis { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long QueryTotal { get; set; }
	public double? RecentSearchLoad { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long ScrollCurrent { get; set; }
	public Elastic.Clients.Elasticsearch.Duration? ScrollTime { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan ScrollTimeInMillis { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long ScrollTotal { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long SuggestCurrent { get; set; }
	public Elastic.Clients.Elasticsearch.Duration? SuggestTime { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan SuggestTimeInMillis { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long SuggestTotal { get; set; }
}