// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.ScriptSortConverter))]
public sealed partial class ScriptSort
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ScriptSort(Elastic.Clients.Elasticsearch.Script script)
	{
		Script = script;
	}
#if NET7_0_OR_GREATER
	public ScriptSort()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ScriptSort()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ScriptSort(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public Elastic.Clients.Elasticsearch.SortMode? Mode { get; set; }
	public Elastic.Clients.Elasticsearch.NestedSortValue? Nested { get; set; }
	public Elastic.Clients.Elasticsearch.SortOrder? Order { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Script Script { get; set; }
	public Elastic.Clients.Elasticsearch.ScriptSortType? Type { get; set; }
}

public readonly partial struct ScriptSortDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.ScriptSort Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ScriptSortDescriptor(Elastic.Clients.Elasticsearch.ScriptSort instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ScriptSortDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.ScriptSort(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.ScriptSortDescriptor<TDocument>(Elastic.Clients.Elasticsearch.ScriptSort instance) => new Elastic.Clients.Elasticsearch.ScriptSortDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.ScriptSort(Elastic.Clients.Elasticsearch.ScriptSortDescriptor<TDocument> descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.ScriptSortDescriptor<TDocument> Mode(Elastic.Clients.Elasticsearch.SortMode? value)
	{
		Instance.Mode = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptSortDescriptor<TDocument> Nested(Elastic.Clients.Elasticsearch.NestedSortValue? value)
	{
		Instance.Nested = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptSortDescriptor<TDocument> Nested(System.Action<Elastic.Clients.Elasticsearch.NestedSortValueDescriptor<TDocument>> action)
	{
		Instance.Nested = Elastic.Clients.Elasticsearch.NestedSortValueDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptSortDescriptor<TDocument> Order(Elastic.Clients.Elasticsearch.SortOrder? value)
	{
		Instance.Order = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptSortDescriptor<TDocument> Script(Elastic.Clients.Elasticsearch.Script value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptSortDescriptor<TDocument> Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptSortDescriptor<TDocument> Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptSortDescriptor<TDocument> Type(Elastic.Clients.Elasticsearch.ScriptSortType? value)
	{
		Instance.Type = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.ScriptSort Build(System.Action<Elastic.Clients.Elasticsearch.ScriptSortDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.ScriptSortDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.ScriptSort(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct ScriptSortDescriptor
{
	internal Elastic.Clients.Elasticsearch.ScriptSort Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ScriptSortDescriptor(Elastic.Clients.Elasticsearch.ScriptSort instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ScriptSortDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.ScriptSort(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.ScriptSortDescriptor(Elastic.Clients.Elasticsearch.ScriptSort instance) => new Elastic.Clients.Elasticsearch.ScriptSortDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.ScriptSort(Elastic.Clients.Elasticsearch.ScriptSortDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.ScriptSortDescriptor Mode(Elastic.Clients.Elasticsearch.SortMode? value)
	{
		Instance.Mode = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptSortDescriptor Nested(Elastic.Clients.Elasticsearch.NestedSortValue? value)
	{
		Instance.Nested = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptSortDescriptor Nested(System.Action<Elastic.Clients.Elasticsearch.NestedSortValueDescriptor> action)
	{
		Instance.Nested = Elastic.Clients.Elasticsearch.NestedSortValueDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptSortDescriptor Nested<T>(System.Action<Elastic.Clients.Elasticsearch.NestedSortValueDescriptor<T>> action)
	{
		Instance.Nested = Elastic.Clients.Elasticsearch.NestedSortValueDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptSortDescriptor Order(Elastic.Clients.Elasticsearch.SortOrder? value)
	{
		Instance.Order = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptSortDescriptor Script(Elastic.Clients.Elasticsearch.Script value)
	{
		Instance.Script = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptSortDescriptor Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptSortDescriptor Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptSortDescriptor Type(Elastic.Clients.Elasticsearch.ScriptSortType? value)
	{
		Instance.Type = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.ScriptSort Build(System.Action<Elastic.Clients.Elasticsearch.ScriptSortDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.ScriptSortDescriptor(new Elastic.Clients.Elasticsearch.ScriptSort(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}