// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.ScriptLanguageConverter))]
public readonly partial struct ScriptLanguage : Elastic.Clients.Elasticsearch.Serialization.IEnumStruct<Elastic.Clients.Elasticsearch.ScriptLanguage>
{
	public ScriptLanguage(string value) => Value = value;
#if NET7_0_OR_GREATER
	static ScriptLanguage IEnumStruct<ScriptLanguage>.Create(string value) => value;
#else
	ScriptLanguage IEnumStruct<ScriptLanguage>.Create(string value) => value;
#endif
	public readonly string Value { get; }

	/// <summary>
	/// <para>
	/// Lucene’s expressions language, compiles a JavaScript expression to bytecode.
	/// </para>
	/// </summary>
	public static ScriptLanguage Expression { get; } = new ScriptLanguage("expression");

	/// <summary>
	/// <para>
	/// Expert Java API
	/// </para>
	/// </summary>
	public static ScriptLanguage Java { get; } = new ScriptLanguage("java");

	/// <summary>
	/// <para>
	/// Mustache templated, used for templates.
	/// </para>
	/// </summary>
	public static ScriptLanguage Mustache { get; } = new ScriptLanguage("mustache");

	/// <summary>
	/// <para>
	/// Painless scripting language, purpose-built for Elasticsearch.
	/// </para>
	/// </summary>
	public static ScriptLanguage Painless { get; } = new ScriptLanguage("painless");

	public override string ToString() => Value ?? string.Empty;

	public static implicit operator string(ScriptLanguage @enum) => @enum.Value;
	public static implicit operator ScriptLanguage(string value) => new(value);

	public override int GetHashCode() => Value.GetHashCode();
	public override bool Equals(object obj) => obj is ScriptLanguage other && this.Equals(other);
	public bool Equals(ScriptLanguage other) => Value == other.Value;

	public static bool operator ==(ScriptLanguage a, ScriptLanguage b) => a.Equals(b);
	public static bool operator !=(ScriptLanguage a, ScriptLanguage b) => !(a == b);
}