// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.ScriptConverter))]
public sealed partial class Script
{
#if NET7_0_OR_GREATER
	public Script()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public Script()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Script(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The <c>id</c> for a stored script.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Id? Id { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the language the script is written in.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ScriptLanguage? Lang { get; set; }
	public System.Collections.Generic.IDictionary<string, string>? Options { get; set; }

	/// <summary>
	/// <para>
	/// Specifies any named parameters that are passed into the script as variables.
	/// Use parameters instead of hard-coded values to decrease compile time.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Params { get; set; }

	/// <summary>
	/// <para>
	/// The script source.
	/// </para>
	/// </summary>
	public string? Source { get; set; }
}

public readonly partial struct ScriptDescriptor
{
	internal Elastic.Clients.Elasticsearch.Script Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ScriptDescriptor(Elastic.Clients.Elasticsearch.Script instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ScriptDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Script(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.ScriptDescriptor(Elastic.Clients.Elasticsearch.Script instance) => new Elastic.Clients.Elasticsearch.ScriptDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Script(Elastic.Clients.Elasticsearch.ScriptDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The <c>id</c> for a stored script.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ScriptDescriptor Id(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the language the script is written in.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ScriptDescriptor Lang(Elastic.Clients.Elasticsearch.ScriptLanguage? value)
	{
		Instance.Lang = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptDescriptor Options(System.Collections.Generic.IDictionary<string, string>? value)
	{
		Instance.Options = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptDescriptor Options()
	{
		Instance.Options = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptDescriptor Options(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString>? action)
	{
		Instance.Options = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptDescriptor AddOption(string key, string value)
	{
		Instance.Options ??= new System.Collections.Generic.Dictionary<string, string>();
		Instance.Options.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies any named parameters that are passed into the script as variables.
	/// Use parameters instead of hard-coded values to decrease compile time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ScriptDescriptor Params(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Params = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies any named parameters that are passed into the script as variables.
	/// Use parameters instead of hard-coded values to decrease compile time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ScriptDescriptor Params()
	{
		Instance.Params = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies any named parameters that are passed into the script as variables.
	/// Use parameters instead of hard-coded values to decrease compile time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ScriptDescriptor Params(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Params = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptDescriptor AddParam(string key, object value)
	{
		Instance.Params ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Params.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// The script source.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ScriptDescriptor Source(string? value)
	{
		Instance.Source = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Script Build(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Script(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.ScriptDescriptor(new Elastic.Clients.Elasticsearch.Script(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}