// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.RuleRetrieverConverter))]
public sealed partial class RuleRetriever
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RuleRetriever(object matchCriteria, Elastic.Clients.Elasticsearch.Retriever retriever, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Id> rulesetIds)
	{
		MatchCriteria = matchCriteria;
		Retriever = retriever;
		RulesetIds = rulesetIds;
	}
#if NET7_0_OR_GREATER
	public RuleRetriever()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public RuleRetriever()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RuleRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? Filter { get; set; }

	/// <summary>
	/// <para>
	/// The match criteria that will determine if a rule in the provided rulesets should be applied.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	object MatchCriteria { get; set; }

	/// <summary>
	/// <para>
	/// Minimum _score for matching documents. Documents with a lower _score are not included in the top documents.
	/// </para>
	/// </summary>
	public float? MinScore { get; set; }

	/// <summary>
	/// <para>
	/// Retriever name.
	/// </para>
	/// </summary>
	public string? Name { get; set; }

	/// <summary>
	/// <para>
	/// This value determines the size of the individual result set.
	/// </para>
	/// </summary>
	public int? RankWindowSize { get; set; }

	/// <summary>
	/// <para>
	/// The retriever whose results rules should be applied to.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Retriever Retriever { get; set; }

	/// <summary>
	/// <para>
	/// The ruleset IDs containing the rules this retriever is evaluating against.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Id> RulesetIds { get; set; }
}

public readonly partial struct RuleRetrieverDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.RuleRetriever Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RuleRetrieverDescriptor(Elastic.Clients.Elasticsearch.RuleRetriever instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RuleRetrieverDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.RuleRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor<TDocument>(Elastic.Clients.Elasticsearch.RuleRetriever instance) => new Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.RuleRetriever(Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor<TDocument> Filter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor<TDocument> Filter(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.Filter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor<TDocument> Filter(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The match criteria that will determine if a rule in the provided rulesets should be applied.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor<TDocument> MatchCriteria(object value)
	{
		Instance.MatchCriteria = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum _score for matching documents. Documents with a lower _score are not included in the top documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor<TDocument> MinScore(float? value)
	{
		Instance.MinScore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Retriever name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor<TDocument> Name(string? value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This value determines the size of the individual result set.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor<TDocument> RankWindowSize(int? value)
	{
		Instance.RankWindowSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The retriever whose results rules should be applied to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor<TDocument> Retriever(Elastic.Clients.Elasticsearch.Retriever value)
	{
		Instance.Retriever = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The retriever whose results rules should be applied to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor<TDocument> Retriever(System.Action<Elastic.Clients.Elasticsearch.RetrieverDescriptor<TDocument>> action)
	{
		Instance.Retriever = Elastic.Clients.Elasticsearch.RetrieverDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The ruleset IDs containing the rules this retriever is evaluating against.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor<TDocument> RulesetIds(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Id> value)
	{
		Instance.RulesetIds = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The ruleset IDs containing the rules this retriever is evaluating against.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor<TDocument> RulesetIds(params Elastic.Clients.Elasticsearch.Id[] values)
	{
		Instance.RulesetIds = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.RuleRetriever Build(System.Action<Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.RuleRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct RuleRetrieverDescriptor
{
	internal Elastic.Clients.Elasticsearch.RuleRetriever Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RuleRetrieverDescriptor(Elastic.Clients.Elasticsearch.RuleRetriever instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RuleRetrieverDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.RuleRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor(Elastic.Clients.Elasticsearch.RuleRetriever instance) => new Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.RuleRetriever(Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor Filter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor Filter(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.Filter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor Filter(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor Filter<T>(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The match criteria that will determine if a rule in the provided rulesets should be applied.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor MatchCriteria(object value)
	{
		Instance.MatchCriteria = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum _score for matching documents. Documents with a lower _score are not included in the top documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor MinScore(float? value)
	{
		Instance.MinScore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Retriever name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor Name(string? value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This value determines the size of the individual result set.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor RankWindowSize(int? value)
	{
		Instance.RankWindowSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The retriever whose results rules should be applied to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor Retriever(Elastic.Clients.Elasticsearch.Retriever value)
	{
		Instance.Retriever = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The retriever whose results rules should be applied to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor Retriever(System.Action<Elastic.Clients.Elasticsearch.RetrieverDescriptor> action)
	{
		Instance.Retriever = Elastic.Clients.Elasticsearch.RetrieverDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The retriever whose results rules should be applied to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor Retriever<T>(System.Action<Elastic.Clients.Elasticsearch.RetrieverDescriptor<T>> action)
	{
		Instance.Retriever = Elastic.Clients.Elasticsearch.RetrieverDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The ruleset IDs containing the rules this retriever is evaluating against.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor RulesetIds(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Id> value)
	{
		Instance.RulesetIds = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The ruleset IDs containing the rules this retriever is evaluating against.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor RulesetIds(params Elastic.Clients.Elasticsearch.Id[] values)
	{
		Instance.RulesetIds = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.RuleRetriever Build(System.Action<Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.RuleRetrieverDescriptor(new Elastic.Clients.Elasticsearch.RuleRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}