// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.RrfRankConverter))]
public sealed partial class RrfRank
{
#if NET7_0_OR_GREATER
	public RrfRank()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public RrfRank()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RrfRank(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// How much influence documents in individual result sets per query have over the final ranked result set
	/// </para>
	/// </summary>
	public long? RankConstant { get; set; }

	/// <summary>
	/// <para>
	/// Size of the individual result sets per query
	/// </para>
	/// </summary>
	public long? RankWindowSize { get; set; }
}

public readonly partial struct RrfRankDescriptor
{
	internal Elastic.Clients.Elasticsearch.RrfRank Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RrfRankDescriptor(Elastic.Clients.Elasticsearch.RrfRank instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RrfRankDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.RrfRank(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.RrfRankDescriptor(Elastic.Clients.Elasticsearch.RrfRank instance) => new Elastic.Clients.Elasticsearch.RrfRankDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.RrfRank(Elastic.Clients.Elasticsearch.RrfRankDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// How much influence documents in individual result sets per query have over the final ranked result set
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRankDescriptor RankConstant(long? value)
	{
		Instance.RankConstant = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Size of the individual result sets per query
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RrfRankDescriptor RankWindowSize(long? value)
	{
		Instance.RankWindowSize = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.RrfRank Build(System.Action<Elastic.Clients.Elasticsearch.RrfRankDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.RrfRank(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.RrfRankDescriptor(new Elastic.Clients.Elasticsearch.RrfRank(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}