// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Rollup;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Rollup.Json.RollupJobStatsConverter))]
public sealed partial class RollupJobStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RollupJobStats(long documentsProcessed, long indexFailures, System.TimeSpan indexTimeInMs, long indexTotal, long pagesProcessed, System.TimeSpan processingTimeInMs, long processingTotal, long rollupsIndexed, long searchFailures, System.TimeSpan searchTimeInMs, long searchTotal, long triggerCount)
	{
		DocumentsProcessed = documentsProcessed;
		IndexFailures = indexFailures;
		IndexTimeInMs = indexTimeInMs;
		IndexTotal = indexTotal;
		PagesProcessed = pagesProcessed;
		ProcessingTimeInMs = processingTimeInMs;
		ProcessingTotal = processingTotal;
		RollupsIndexed = rollupsIndexed;
		SearchFailures = searchFailures;
		SearchTimeInMs = searchTimeInMs;
		SearchTotal = searchTotal;
		TriggerCount = triggerCount;
	}
#if NET7_0_OR_GREATER
	public RollupJobStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public RollupJobStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RollupJobStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public
#if NET7_0_OR_GREATER
	required
#endif
	long DocumentsProcessed { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long IndexFailures { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan IndexTimeInMs { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long IndexTotal { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long PagesProcessed { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan ProcessingTimeInMs { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long ProcessingTotal { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long RollupsIndexed { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long SearchFailures { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan SearchTimeInMs { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long SearchTotal { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long TriggerCount { get; set; }
}