// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Rollup.Json;

public sealed partial class RollupJobStatsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Rollup.RollupJobStats>
{
	private static readonly System.Text.Json.JsonEncodedText PropDocumentsProcessed = System.Text.Json.JsonEncodedText.Encode("documents_processed");
	private static readonly System.Text.Json.JsonEncodedText PropIndexFailures = System.Text.Json.JsonEncodedText.Encode("index_failures");
	private static readonly System.Text.Json.JsonEncodedText PropIndexTimeInMs = System.Text.Json.JsonEncodedText.Encode("index_time_in_ms");
	private static readonly System.Text.Json.JsonEncodedText PropIndexTotal = System.Text.Json.JsonEncodedText.Encode("index_total");
	private static readonly System.Text.Json.JsonEncodedText PropPagesProcessed = System.Text.Json.JsonEncodedText.Encode("pages_processed");
	private static readonly System.Text.Json.JsonEncodedText PropProcessingTimeInMs = System.Text.Json.JsonEncodedText.Encode("processing_time_in_ms");
	private static readonly System.Text.Json.JsonEncodedText PropProcessingTotal = System.Text.Json.JsonEncodedText.Encode("processing_total");
	private static readonly System.Text.Json.JsonEncodedText PropRollupsIndexed = System.Text.Json.JsonEncodedText.Encode("rollups_indexed");
	private static readonly System.Text.Json.JsonEncodedText PropSearchFailures = System.Text.Json.JsonEncodedText.Encode("search_failures");
	private static readonly System.Text.Json.JsonEncodedText PropSearchTimeInMs = System.Text.Json.JsonEncodedText.Encode("search_time_in_ms");
	private static readonly System.Text.Json.JsonEncodedText PropSearchTotal = System.Text.Json.JsonEncodedText.Encode("search_total");
	private static readonly System.Text.Json.JsonEncodedText PropTriggerCount = System.Text.Json.JsonEncodedText.Encode("trigger_count");

	public override Elastic.Clients.Elasticsearch.Rollup.RollupJobStats Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<long> propDocumentsProcessed = default;
		LocalJsonValue<long> propIndexFailures = default;
		LocalJsonValue<System.TimeSpan> propIndexTimeInMs = default;
		LocalJsonValue<long> propIndexTotal = default;
		LocalJsonValue<long> propPagesProcessed = default;
		LocalJsonValue<System.TimeSpan> propProcessingTimeInMs = default;
		LocalJsonValue<long> propProcessingTotal = default;
		LocalJsonValue<long> propRollupsIndexed = default;
		LocalJsonValue<long> propSearchFailures = default;
		LocalJsonValue<System.TimeSpan> propSearchTimeInMs = default;
		LocalJsonValue<long> propSearchTotal = default;
		LocalJsonValue<long> propTriggerCount = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propDocumentsProcessed.TryReadProperty(ref reader, options, PropDocumentsProcessed, null))
			{
				continue;
			}

			if (propIndexFailures.TryReadProperty(ref reader, options, PropIndexFailures, null))
			{
				continue;
			}

			if (propIndexTimeInMs.TryReadProperty(ref reader, options, PropIndexTimeInMs, static System.TimeSpan (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker))))
			{
				continue;
			}

			if (propIndexTotal.TryReadProperty(ref reader, options, PropIndexTotal, null))
			{
				continue;
			}

			if (propPagesProcessed.TryReadProperty(ref reader, options, PropPagesProcessed, null))
			{
				continue;
			}

			if (propProcessingTimeInMs.TryReadProperty(ref reader, options, PropProcessingTimeInMs, static System.TimeSpan (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker))))
			{
				continue;
			}

			if (propProcessingTotal.TryReadProperty(ref reader, options, PropProcessingTotal, null))
			{
				continue;
			}

			if (propRollupsIndexed.TryReadProperty(ref reader, options, PropRollupsIndexed, null))
			{
				continue;
			}

			if (propSearchFailures.TryReadProperty(ref reader, options, PropSearchFailures, null))
			{
				continue;
			}

			if (propSearchTimeInMs.TryReadProperty(ref reader, options, PropSearchTimeInMs, static System.TimeSpan (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker))))
			{
				continue;
			}

			if (propSearchTotal.TryReadProperty(ref reader, options, PropSearchTotal, null))
			{
				continue;
			}

			if (propTriggerCount.TryReadProperty(ref reader, options, PropTriggerCount, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Rollup.RollupJobStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			DocumentsProcessed = propDocumentsProcessed.Value,
			IndexFailures = propIndexFailures.Value,
			IndexTimeInMs = propIndexTimeInMs.Value,
			IndexTotal = propIndexTotal.Value,
			PagesProcessed = propPagesProcessed.Value,
			ProcessingTimeInMs = propProcessingTimeInMs.Value,
			ProcessingTotal = propProcessingTotal.Value,
			RollupsIndexed = propRollupsIndexed.Value,
			SearchFailures = propSearchFailures.Value,
			SearchTimeInMs = propSearchTimeInMs.Value,
			SearchTotal = propSearchTotal.Value,
			TriggerCount = propTriggerCount.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Rollup.RollupJobStats value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropDocumentsProcessed, value.DocumentsProcessed, null, null);
		writer.WriteProperty(options, PropIndexFailures, value.IndexFailures, null, null);
		writer.WriteProperty(options, PropIndexTimeInMs, value.IndexTimeInMs, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan v) => w.WriteValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker)));
		writer.WriteProperty(options, PropIndexTotal, value.IndexTotal, null, null);
		writer.WriteProperty(options, PropPagesProcessed, value.PagesProcessed, null, null);
		writer.WriteProperty(options, PropProcessingTimeInMs, value.ProcessingTimeInMs, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan v) => w.WriteValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker)));
		writer.WriteProperty(options, PropProcessingTotal, value.ProcessingTotal, null, null);
		writer.WriteProperty(options, PropRollupsIndexed, value.RollupsIndexed, null, null);
		writer.WriteProperty(options, PropSearchFailures, value.SearchFailures, null, null);
		writer.WriteProperty(options, PropSearchTimeInMs, value.SearchTimeInMs, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan v) => w.WriteValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker)));
		writer.WriteProperty(options, PropSearchTotal, value.SearchTotal, null, null);
		writer.WriteProperty(options, PropTriggerCount, value.TriggerCount, null, null);
		writer.WriteEndObject();
	}
}