// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Rollup.Json;

public sealed partial class RollupJobConfigurationConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Rollup.RollupJobConfiguration>
{
	private static readonly System.Text.Json.JsonEncodedText PropCron = System.Text.Json.JsonEncodedText.Encode("cron");
	private static readonly System.Text.Json.JsonEncodedText PropGroups = System.Text.Json.JsonEncodedText.Encode("groups");
	private static readonly System.Text.Json.JsonEncodedText PropId = System.Text.Json.JsonEncodedText.Encode("id");
	private static readonly System.Text.Json.JsonEncodedText PropIndexPattern = System.Text.Json.JsonEncodedText.Encode("index_pattern");
	private static readonly System.Text.Json.JsonEncodedText PropMetrics = System.Text.Json.JsonEncodedText.Encode("metrics");
	private static readonly System.Text.Json.JsonEncodedText PropPageSize = System.Text.Json.JsonEncodedText.Encode("page_size");
	private static readonly System.Text.Json.JsonEncodedText PropRollupIndex = System.Text.Json.JsonEncodedText.Encode("rollup_index");
	private static readonly System.Text.Json.JsonEncodedText PropTimeout = System.Text.Json.JsonEncodedText.Encode("timeout");

	public override Elastic.Clients.Elasticsearch.Rollup.RollupJobConfiguration Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string> propCron = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Rollup.Groupings> propGroups = default;
		LocalJsonValue<string> propId = default;
		LocalJsonValue<string> propIndexPattern = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Rollup.FieldMetric>> propMetrics = default;
		LocalJsonValue<long> propPageSize = default;
		LocalJsonValue<string> propRollupIndex = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration> propTimeout = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propCron.TryReadProperty(ref reader, options, PropCron, null))
			{
				continue;
			}

			if (propGroups.TryReadProperty(ref reader, options, PropGroups, null))
			{
				continue;
			}

			if (propId.TryReadProperty(ref reader, options, PropId, null))
			{
				continue;
			}

			if (propIndexPattern.TryReadProperty(ref reader, options, PropIndexPattern, null))
			{
				continue;
			}

			if (propMetrics.TryReadProperty(ref reader, options, PropMetrics, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Rollup.FieldMetric> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Rollup.FieldMetric>(o, null)!))
			{
				continue;
			}

			if (propPageSize.TryReadProperty(ref reader, options, PropPageSize, null))
			{
				continue;
			}

			if (propRollupIndex.TryReadProperty(ref reader, options, PropRollupIndex, null))
			{
				continue;
			}

			if (propTimeout.TryReadProperty(ref reader, options, PropTimeout, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Rollup.RollupJobConfiguration(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Cron = propCron.Value,
			Groups = propGroups.Value,
			Id = propId.Value,
			IndexPattern = propIndexPattern.Value,
			Metrics = propMetrics.Value,
			PageSize = propPageSize.Value,
			RollupIndex = propRollupIndex.Value,
			Timeout = propTimeout.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Rollup.RollupJobConfiguration value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropCron, value.Cron, null, null);
		writer.WriteProperty(options, PropGroups, value.Groups, null, null);
		writer.WriteProperty(options, PropId, value.Id, null, null);
		writer.WriteProperty(options, PropIndexPattern, value.IndexPattern, null, null);
		writer.WriteProperty(options, PropMetrics, value.Metrics, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Rollup.FieldMetric> v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Rollup.FieldMetric>(o, v, null));
		writer.WriteProperty(options, PropPageSize, value.PageSize, null, null);
		writer.WriteProperty(options, PropRollupIndex, value.RollupIndex, null, null);
		writer.WriteProperty(options, PropTimeout, value.Timeout, null, null);
		writer.WriteEndObject();
	}
}