// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Rollup;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Rollup.Json.RollupJobConverter))]
public sealed partial class RollupJob
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RollupJob(Elastic.Clients.Elasticsearch.Rollup.RollupJobConfiguration config, Elastic.Clients.Elasticsearch.Rollup.RollupJobStats stats, Elastic.Clients.Elasticsearch.Rollup.RollupJobStatus status)
	{
		Config = config;
		Stats = stats;
		Status = status;
	}
#if NET7_0_OR_GREATER
	public RollupJob()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public RollupJob()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RollupJob(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The rollup job configuration.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Rollup.RollupJobConfiguration Config { get; set; }

	/// <summary>
	/// <para>
	/// Transient statistics about the rollup job, such as how many documents have been processed and how many rollup summary docs have been indexed.
	/// These stats are not persisted.
	/// If a node is restarted, these stats are reset.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Rollup.RollupJobStats Stats { get; set; }

	/// <summary>
	/// <para>
	/// The current status of the indexer for the rollup job.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Rollup.RollupJobStatus Status { get; set; }
}