// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Rollup.Json;

public sealed partial class MetricConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Rollup.Metric>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAvg = System.Text.Json.JsonEncodedText.Encode("avg");
	private static readonly System.Text.Json.JsonEncodedText MemberMax = System.Text.Json.JsonEncodedText.Encode("max");
	private static readonly System.Text.Json.JsonEncodedText MemberMin = System.Text.Json.JsonEncodedText.Encode("min");
	private static readonly System.Text.Json.JsonEncodedText MemberSum = System.Text.Json.JsonEncodedText.Encode("sum");
	private static readonly System.Text.Json.JsonEncodedText MemberValueCount = System.Text.Json.JsonEncodedText.Encode("value_count");

	public override Elastic.Clients.Elasticsearch.Rollup.Metric Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAvg))
		{
			return Elastic.Clients.Elasticsearch.Rollup.Metric.Avg;
		}

		if (reader.ValueTextEquals(MemberMax))
		{
			return Elastic.Clients.Elasticsearch.Rollup.Metric.Max;
		}

		if (reader.ValueTextEquals(MemberMin))
		{
			return Elastic.Clients.Elasticsearch.Rollup.Metric.Min;
		}

		if (reader.ValueTextEquals(MemberSum))
		{
			return Elastic.Clients.Elasticsearch.Rollup.Metric.Sum;
		}

		if (reader.ValueTextEquals(MemberValueCount))
		{
			return Elastic.Clients.Elasticsearch.Rollup.Metric.ValueCount;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAvg.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Rollup.Metric.Avg;
		}

		if (string.Equals(value, MemberMax.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Rollup.Metric.Max;
		}

		if (string.Equals(value, MemberMin.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Rollup.Metric.Min;
		}

		if (string.Equals(value, MemberSum.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Rollup.Metric.Sum;
		}

		if (string.Equals(value, MemberValueCount.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Rollup.Metric.ValueCount;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Rollup.Metric)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Rollup.Metric value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Rollup.Metric.Avg:
				writer.WriteStringValue(MemberAvg);
				break;
			case Elastic.Clients.Elasticsearch.Rollup.Metric.Max:
				writer.WriteStringValue(MemberMax);
				break;
			case Elastic.Clients.Elasticsearch.Rollup.Metric.Min:
				writer.WriteStringValue(MemberMin);
				break;
			case Elastic.Clients.Elasticsearch.Rollup.Metric.Sum:
				writer.WriteStringValue(MemberSum);
				break;
			case Elastic.Clients.Elasticsearch.Rollup.Metric.ValueCount:
				writer.WriteStringValue(MemberValueCount);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Rollup.Metric)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Rollup.Metric ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Rollup.Metric value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}