// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Rollup.Json;

public sealed partial class IndexingJobStateConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Rollup.IndexingJobState>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAborting = System.Text.Json.JsonEncodedText.Encode("aborting");
	private static readonly System.Text.Json.JsonEncodedText MemberIndexing = System.Text.Json.JsonEncodedText.Encode("indexing");
	private static readonly System.Text.Json.JsonEncodedText MemberStarted = System.Text.Json.JsonEncodedText.Encode("started");
	private static readonly System.Text.Json.JsonEncodedText MemberStopped = System.Text.Json.JsonEncodedText.Encode("stopped");
	private static readonly System.Text.Json.JsonEncodedText MemberStopping = System.Text.Json.JsonEncodedText.Encode("stopping");

	public override Elastic.Clients.Elasticsearch.Rollup.IndexingJobState Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAborting))
		{
			return Elastic.Clients.Elasticsearch.Rollup.IndexingJobState.Aborting;
		}

		if (reader.ValueTextEquals(MemberIndexing))
		{
			return Elastic.Clients.Elasticsearch.Rollup.IndexingJobState.Indexing;
		}

		if (reader.ValueTextEquals(MemberStarted))
		{
			return Elastic.Clients.Elasticsearch.Rollup.IndexingJobState.Started;
		}

		if (reader.ValueTextEquals(MemberStopped))
		{
			return Elastic.Clients.Elasticsearch.Rollup.IndexingJobState.Stopped;
		}

		if (reader.ValueTextEquals(MemberStopping))
		{
			return Elastic.Clients.Elasticsearch.Rollup.IndexingJobState.Stopping;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAborting.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Rollup.IndexingJobState.Aborting;
		}

		if (string.Equals(value, MemberIndexing.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Rollup.IndexingJobState.Indexing;
		}

		if (string.Equals(value, MemberStarted.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Rollup.IndexingJobState.Started;
		}

		if (string.Equals(value, MemberStopped.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Rollup.IndexingJobState.Stopped;
		}

		if (string.Equals(value, MemberStopping.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Rollup.IndexingJobState.Stopping;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Rollup.IndexingJobState)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Rollup.IndexingJobState value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Rollup.IndexingJobState.Aborting:
				writer.WriteStringValue(MemberAborting);
				break;
			case Elastic.Clients.Elasticsearch.Rollup.IndexingJobState.Indexing:
				writer.WriteStringValue(MemberIndexing);
				break;
			case Elastic.Clients.Elasticsearch.Rollup.IndexingJobState.Started:
				writer.WriteStringValue(MemberStarted);
				break;
			case Elastic.Clients.Elasticsearch.Rollup.IndexingJobState.Stopped:
				writer.WriteStringValue(MemberStopped);
				break;
			case Elastic.Clients.Elasticsearch.Rollup.IndexingJobState.Stopping:
				writer.WriteStringValue(MemberStopping);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Rollup.IndexingJobState)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Rollup.IndexingJobState ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Rollup.IndexingJobState value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}