// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Rollup;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Rollup.Json.HistogramGroupingConverter))]
public sealed partial class HistogramGrouping
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public HistogramGrouping(Elastic.Clients.Elasticsearch.Fields fields, long interval)
	{
		Fields = fields;
		Interval = interval;
	}
#if NET7_0_OR_GREATER
	public HistogramGrouping()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public HistogramGrouping()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal HistogramGrouping(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The set of fields that you wish to build histograms for.
	/// All fields specified must be some kind of numeric.
	/// Order does not matter.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Fields Fields { get; set; }

	/// <summary>
	/// <para>
	/// The interval of histogram buckets to be generated when rolling up.
	/// For example, a value of <c>5</c> creates buckets that are five units wide (<c>0-5</c>, <c>5-10</c>, etc).
	/// Note that only one interval can be specified in the histogram group, meaning that all fields being grouped via the histogram must share the same interval.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Interval { get; set; }
}

public readonly partial struct HistogramGroupingDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Rollup.HistogramGrouping Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public HistogramGroupingDescriptor(Elastic.Clients.Elasticsearch.Rollup.HistogramGrouping instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public HistogramGroupingDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Rollup.HistogramGrouping(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Rollup.HistogramGroupingDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Rollup.HistogramGrouping instance) => new Elastic.Clients.Elasticsearch.Rollup.HistogramGroupingDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Rollup.HistogramGrouping(Elastic.Clients.Elasticsearch.Rollup.HistogramGroupingDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The set of fields that you wish to build histograms for.
	/// All fields specified must be some kind of numeric.
	/// Order does not matter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.HistogramGroupingDescriptor<TDocument> Fields(Elastic.Clients.Elasticsearch.Fields value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The set of fields that you wish to build histograms for.
	/// All fields specified must be some kind of numeric.
	/// Order does not matter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.HistogramGroupingDescriptor<TDocument> Fields(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The interval of histogram buckets to be generated when rolling up.
	/// For example, a value of <c>5</c> creates buckets that are five units wide (<c>0-5</c>, <c>5-10</c>, etc).
	/// Note that only one interval can be specified in the histogram group, meaning that all fields being grouped via the histogram must share the same interval.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.HistogramGroupingDescriptor<TDocument> Interval(long value)
	{
		Instance.Interval = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Rollup.HistogramGrouping Build(System.Action<Elastic.Clients.Elasticsearch.Rollup.HistogramGroupingDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.HistogramGroupingDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Rollup.HistogramGrouping(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct HistogramGroupingDescriptor
{
	internal Elastic.Clients.Elasticsearch.Rollup.HistogramGrouping Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public HistogramGroupingDescriptor(Elastic.Clients.Elasticsearch.Rollup.HistogramGrouping instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public HistogramGroupingDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Rollup.HistogramGrouping(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Rollup.HistogramGroupingDescriptor(Elastic.Clients.Elasticsearch.Rollup.HistogramGrouping instance) => new Elastic.Clients.Elasticsearch.Rollup.HistogramGroupingDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Rollup.HistogramGrouping(Elastic.Clients.Elasticsearch.Rollup.HistogramGroupingDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The set of fields that you wish to build histograms for.
	/// All fields specified must be some kind of numeric.
	/// Order does not matter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.HistogramGroupingDescriptor Fields(Elastic.Clients.Elasticsearch.Fields value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The set of fields that you wish to build histograms for.
	/// All fields specified must be some kind of numeric.
	/// Order does not matter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.HistogramGroupingDescriptor Fields<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The interval of histogram buckets to be generated when rolling up.
	/// For example, a value of <c>5</c> creates buckets that are five units wide (<c>0-5</c>, <c>5-10</c>, etc).
	/// Note that only one interval can be specified in the histogram group, meaning that all fields being grouped via the histogram must share the same interval.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.HistogramGroupingDescriptor Interval(long value)
	{
		Instance.Interval = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Rollup.HistogramGrouping Build(System.Action<Elastic.Clients.Elasticsearch.Rollup.HistogramGroupingDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.HistogramGroupingDescriptor(new Elastic.Clients.Elasticsearch.Rollup.HistogramGrouping(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}