// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Rollup;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Rollup.Json.FieldMetricConverter))]
public sealed partial class FieldMetric
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldMetric(Elastic.Clients.Elasticsearch.Field field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Rollup.Metric> metrics)
	{
		Field = field;
		Metrics = metrics;
	}
#if NET7_0_OR_GREATER
	public FieldMetric()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public FieldMetric()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal FieldMetric(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The field to collect metrics for. This must be a numeric of some kind.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// An array of metrics to collect for the field. At least one metric must be configured.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Rollup.Metric> Metrics { get; set; }
}

public readonly partial struct FieldMetricDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Rollup.FieldMetric Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldMetricDescriptor(Elastic.Clients.Elasticsearch.Rollup.FieldMetric instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldMetricDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Rollup.FieldMetric(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Rollup.FieldMetricDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Rollup.FieldMetric instance) => new Elastic.Clients.Elasticsearch.Rollup.FieldMetricDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Rollup.FieldMetric(Elastic.Clients.Elasticsearch.Rollup.FieldMetricDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The field to collect metrics for. This must be a numeric of some kind.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.FieldMetricDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to collect metrics for. This must be a numeric of some kind.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.FieldMetricDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of metrics to collect for the field. At least one metric must be configured.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.FieldMetricDescriptor<TDocument> Metrics(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Rollup.Metric> value)
	{
		Instance.Metrics = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of metrics to collect for the field. At least one metric must be configured.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.FieldMetricDescriptor<TDocument> Metrics(params Elastic.Clients.Elasticsearch.Rollup.Metric[] values)
	{
		Instance.Metrics = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Rollup.FieldMetric Build(System.Action<Elastic.Clients.Elasticsearch.Rollup.FieldMetricDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.FieldMetricDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Rollup.FieldMetric(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct FieldMetricDescriptor
{
	internal Elastic.Clients.Elasticsearch.Rollup.FieldMetric Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldMetricDescriptor(Elastic.Clients.Elasticsearch.Rollup.FieldMetric instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldMetricDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Rollup.FieldMetric(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Rollup.FieldMetricDescriptor(Elastic.Clients.Elasticsearch.Rollup.FieldMetric instance) => new Elastic.Clients.Elasticsearch.Rollup.FieldMetricDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Rollup.FieldMetric(Elastic.Clients.Elasticsearch.Rollup.FieldMetricDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The field to collect metrics for. This must be a numeric of some kind.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.FieldMetricDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to collect metrics for. This must be a numeric of some kind.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.FieldMetricDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of metrics to collect for the field. At least one metric must be configured.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.FieldMetricDescriptor Metrics(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Rollup.Metric> value)
	{
		Instance.Metrics = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of metrics to collect for the field. At least one metric must be configured.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.FieldMetricDescriptor Metrics(params Elastic.Clients.Elasticsearch.Rollup.Metric[] values)
	{
		Instance.Metrics = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Rollup.FieldMetric Build(System.Action<Elastic.Clients.Elasticsearch.Rollup.FieldMetricDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.FieldMetricDescriptor(new Elastic.Clients.Elasticsearch.Rollup.FieldMetric(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}