// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Rollup;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Rollup.Json.DateHistogramGroupingConverter))]
public sealed partial class DateHistogramGrouping
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateHistogramGrouping(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}
#if NET7_0_OR_GREATER
	public DateHistogramGrouping()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DateHistogramGrouping()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DateHistogramGrouping(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The interval of time buckets to be generated when rolling up.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? CalendarInterval { get; set; }

	/// <summary>
	/// <para>
	/// How long to wait before rolling up new documents.
	/// By default, the indexer attempts to roll up all data that is available.
	/// However, it is not uncommon for data to arrive out of order.
	/// The indexer is unable to deal with data that arrives after a time-span has been rolled up.
	/// You need to specify a delay that matches the longest period of time you expect out-of-order data to arrive.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Delay { get; set; }

	/// <summary>
	/// <para>
	/// The date field that is to be rolled up.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// The interval of time buckets to be generated when rolling up.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? FixedInterval { get; set; }
	public string? Format { get; set; }
	public Elastic.Clients.Elasticsearch.Duration? Interval { get; set; }

	/// <summary>
	/// <para>
	/// Defines what <c>time_zone</c> the rollup documents are stored as.
	/// Unlike raw data, which can shift timezones on the fly, rolled documents have to be stored with a specific timezone.
	/// By default, rollup documents are stored in <c>UTC</c>.
	/// </para>
	/// </summary>
	public string? TimeZone { get; set; }
}

public readonly partial struct DateHistogramGroupingDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Rollup.DateHistogramGrouping Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateHistogramGroupingDescriptor(Elastic.Clients.Elasticsearch.Rollup.DateHistogramGrouping instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateHistogramGroupingDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Rollup.DateHistogramGrouping(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Rollup.DateHistogramGrouping instance) => new Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Rollup.DateHistogramGrouping(Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The interval of time buckets to be generated when rolling up.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor<TDocument> CalendarInterval(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.CalendarInterval = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// How long to wait before rolling up new documents.
	/// By default, the indexer attempts to roll up all data that is available.
	/// However, it is not uncommon for data to arrive out of order.
	/// The indexer is unable to deal with data that arrives after a time-span has been rolled up.
	/// You need to specify a delay that matches the longest period of time you expect out-of-order data to arrive.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor<TDocument> Delay(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Delay = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The date field that is to be rolled up.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The date field that is to be rolled up.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The interval of time buckets to be generated when rolling up.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor<TDocument> FixedInterval(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.FixedInterval = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor<TDocument> Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor<TDocument> Interval(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Interval = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines what <c>time_zone</c> the rollup documents are stored as.
	/// Unlike raw data, which can shift timezones on the fly, rolled documents have to be stored with a specific timezone.
	/// By default, rollup documents are stored in <c>UTC</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor<TDocument> TimeZone(string? value)
	{
		Instance.TimeZone = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Rollup.DateHistogramGrouping Build(System.Action<Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Rollup.DateHistogramGrouping(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct DateHistogramGroupingDescriptor
{
	internal Elastic.Clients.Elasticsearch.Rollup.DateHistogramGrouping Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateHistogramGroupingDescriptor(Elastic.Clients.Elasticsearch.Rollup.DateHistogramGrouping instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateHistogramGroupingDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Rollup.DateHistogramGrouping(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor(Elastic.Clients.Elasticsearch.Rollup.DateHistogramGrouping instance) => new Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Rollup.DateHistogramGrouping(Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The interval of time buckets to be generated when rolling up.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor CalendarInterval(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.CalendarInterval = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// How long to wait before rolling up new documents.
	/// By default, the indexer attempts to roll up all data that is available.
	/// However, it is not uncommon for data to arrive out of order.
	/// The indexer is unable to deal with data that arrives after a time-span has been rolled up.
	/// You need to specify a delay that matches the longest period of time you expect out-of-order data to arrive.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor Delay(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Delay = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The date field that is to be rolled up.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The date field that is to be rolled up.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The interval of time buckets to be generated when rolling up.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor FixedInterval(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.FixedInterval = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor Interval(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Interval = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines what <c>time_zone</c> the rollup documents are stored as.
	/// Unlike raw data, which can shift timezones on the fly, rolled documents have to be stored with a specific timezone.
	/// By default, rollup documents are stored in <c>UTC</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor TimeZone(string? value)
	{
		Instance.TimeZone = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Rollup.DateHistogramGrouping Build(System.Action<Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.DateHistogramGroupingDescriptor(new Elastic.Clients.Elasticsearch.Rollup.DateHistogramGrouping(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}